/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.topology;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.support.hops.DefaultVertexHopCriteria;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.simple.SimpleGraph;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.provider.topology.LegacyEdge;
import org.opennms.netmgt.graph.provider.topology.LegacyVertex;

public class LegacyBackendGraph
extends SimpleGraph {
    private final GenericGraph delegate;

    public LegacyBackendGraph(GenericGraph genericGraph) {
        super(Objects.requireNonNull(genericGraph.getNamespace()));
        genericGraph.getVertices().forEach(genericVertex -> this.addVertices(new Vertex[]{new LegacyVertex((GenericVertex)genericVertex)}));
        genericGraph.getEdges().forEach(genericEdge -> this.addEdges(new Edge[]{new LegacyEdge((GenericEdge)genericEdge)}));
        this.delegate = genericGraph;
    }

    public List<Criteria> getDefaultCriteria() {
        return this.delegate.getDefaultFocus().getVertexIds().stream().map(vertexId -> new DefaultVertexHopCriteria((VertexRef)new DefaultVertexRef(this.getNamespace(), vertexId))).collect(Collectors.toList());
    }

    public LegacyVertex getVertex(String namespace, String id) {
        return (LegacyVertex)super.getVertex(namespace, id);
    }
}

