/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.legacy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.support.hops.VertexHopCriteria;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.MetaTopologyProvider;
import org.opennms.features.topology.api.topo.TopologyProviderInfo;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.focus.Focus;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.info.DefaultGraphInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.service.GraphProvider;
import org.opennms.netmgt.graph.provider.legacy.LegacyEdge;
import org.opennms.netmgt.graph.provider.legacy.LegacyVertex;

public class LegacyGraphProvider
implements GraphProvider {
    private MetaTopologyProvider delegate;

    public LegacyGraphProvider(MetaTopologyProvider metaTopologyProvider) {
        this.delegate = Objects.requireNonNull(metaTopologyProvider);
    }

    public ImmutableGraph<?, ?> loadGraph() {
        GraphInfo graphInfo = this.getGraphInfo();
        BackendGraph currentGraph = this.delegate.getDefaultGraphProvider().getCurrentGraph();
        GenericGraph.GenericGraphBuilder builder = GenericGraph.builder();
        ((GenericGraph.GenericGraphBuilder)builder.graphInfo(graphInfo).id(currentGraph.getNamespace())).property("enrichment.resolveNodes", (Object)true).property("enrichment.defaultStatus", (Object)true);
        currentGraph.getVertices(new Criteria[0]).forEach(legacyVertex -> {
            LegacyVertex domainVertex = new LegacyVertex((Vertex)legacyVertex);
            GenericVertex genericVertex = domainVertex.asGenericVertex();
            builder.addVertex(genericVertex);
        });
        currentGraph.getEdges(new Criteria[0]).forEach(legacyEdge -> {
            LegacyEdge domainEdge = new LegacyEdge((Edge)legacyEdge);
            GenericEdge genericEdge = domainEdge.asGenericEdge();
            builder.addEdge(genericEdge);
        });
        Set focus = this.delegate.getDefaultGraphProvider().getDefaults().getCriteria().stream().filter(c -> VertexHopCriteria.class.isAssignableFrom(c.getClass())).map(c -> (VertexHopCriteria)c).flatMap(c -> c.getVertices().stream()).map(v -> new VertexRef(v.getNamespace(), v.getId())).collect(Collectors.toSet());
        builder.focus(new Focus("SELECTION", (List)Lists.newArrayList(focus)));
        GenericGraph graph = builder.build();
        return graph;
    }

    public GraphInfo getGraphInfo() {
        org.opennms.features.topology.api.topo.GraphProvider defaultGraphProvider = this.delegate.getDefaultGraphProvider();
        TopologyProviderInfo delegateInfo = defaultGraphProvider.getTopologyProviderInfo();
        DefaultGraphInfo graphInfo = new DefaultGraphInfo(defaultGraphProvider.getNamespace());
        graphInfo.setDescription(delegateInfo.getDescription());
        graphInfo.setLabel(delegateInfo.getName());
        return graphInfo;
    }
}

