/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.nominatim;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.geocoder.ConfigurationUtils;
import org.opennms.features.geocoder.GeocoderConfiguration;
import org.opennms.features.geocoder.GeocoderConfigurationException;

public class NominatimConfiguration
extends GeocoderConfiguration {
    public static final String EMAIL_KEY = "email";
    public static final String REFERER_KEY = "referer";
    public static final String USER_AGENT_KEY = "userAgent";
    public static final String USE_SYSTEM_PROXY_KEY = "useSystemProxy";
    public static final String URL_KEY = "url";
    public static final String ACCEPT_USAGE_TERMS_KEY = "acceptUsageTerms";
    private String referer;
    private String urlTemplate;
    private String userAgent;
    private String emailAddress;
    private boolean useSystemProxy;
    private boolean acceptUsageTerms;

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setUseSystemProxy(boolean useSystemProxy) {
        this.useSystemProxy = useSystemProxy;
    }

    public void setAcceptUsageTerms(boolean acceptUsageTerms) {
        this.acceptUsageTerms = acceptUsageTerms;
    }

    public String getReferer() {
        return this.referer;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public boolean isUseSystemProxy() {
        return this.useSystemProxy;
    }

    public boolean isAcceptUsageTerms() {
        return this.acceptUsageTerms;
    }

    public void validate() throws GeocoderConfigurationException {
        if (!this.acceptUsageTerms) {
            throw new GeocoderConfigurationException(ACCEPT_USAGE_TERMS_KEY, "Please accept the usage terms");
        }
        if (Strings.isNullOrEmpty((String)this.userAgent) && Strings.isNullOrEmpty((String)this.referer)) {
            throw new GeocoderConfigurationException(USER_AGENT_KEY, "Either 'User Agent' or 'Referer' must be provided");
        }
        if (Strings.isNullOrEmpty((String)this.emailAddress)) {
            throw new GeocoderConfigurationException(EMAIL_KEY, "Please provide a valid email address");
        }
        if (Strings.isNullOrEmpty((String)this.urlTemplate)) {
            throw new GeocoderConfigurationException(URL_KEY, "Please provide a value");
        }
        try {
            new URL(this.urlTemplate);
        }
        catch (MalformedURLException e) {
            throw new GeocoderConfigurationException(URL_KEY, "The provided URL ''{0}'' is not valid: ''{1}''", new Object[]{this.urlTemplate, e.getMessage()});
        }
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(EMAIL_KEY, this.emailAddress);
        properties.put(REFERER_KEY, this.referer);
        properties.put(USER_AGENT_KEY, this.userAgent);
        properties.put(USE_SYSTEM_PROXY_KEY, this.useSystemProxy);
        properties.put(URL_KEY, this.urlTemplate);
        properties.put(ACCEPT_USAGE_TERMS_KEY, this.acceptUsageTerms);
        return properties;
    }

    public static NominatimConfiguration fromMap(Map<String, Object> properties) {
        NominatimConfiguration configuration = new NominatimConfiguration();
        configuration.setEmailAddress((String)ConfigurationUtils.getValue(properties, (String)EMAIL_KEY, null));
        configuration.setReferer((String)ConfigurationUtils.getValue(properties, (String)REFERER_KEY, null));
        configuration.setUserAgent((String)ConfigurationUtils.getValue(properties, (String)USER_AGENT_KEY, null));
        configuration.setUseSystemProxy(ConfigurationUtils.getBoolean(properties, (String)USE_SYSTEM_PROXY_KEY, (Boolean)false));
        configuration.setUrlTemplate((String)ConfigurationUtils.getValue(properties, (String)URL_KEY, null));
        configuration.setAcceptUsageTerms(ConfigurationUtils.getBoolean(properties, (String)ACCEPT_USAGE_TERMS_KEY, (Boolean)false));
        return configuration;
    }
}

