/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.google;

import com.google.code.geocoder.model.GeocoderGeometry;
import com.google.code.geocoder.model.GeocoderResult;
import com.google.code.geocoder.model.LatLng;
import org.opennms.features.geocoder.Coordinates;
import org.opennms.features.geocoder.GeocoderException;

public class GoogleCoordinates
extends Coordinates {
    private static final long serialVersionUID = 5665827436870286281L;
    private static final int ROUND_HALF_EVEN = 6;
    private static final int PRECISION = 6;

    public GoogleCoordinates() {
    }

    public GoogleCoordinates(GeocoderResult result) throws GeocoderException {
        if (result == null) {
            throw new GeocoderException("No valid geocoder result found!");
        }
        GeocoderGeometry geometry = result.getGeometry();
        if (geometry == null) {
            throw new GeocoderException("No geometry found in Google geocoding response!");
        }
        LatLng latLng = geometry.getLocation();
        if (latLng == null) {
            throw new GeocoderException("No latitude/longitude found in Google geocoding response!");
        }
        String lonLatString = latLng.getLng().setScale(6, 6).toString() + "," + latLng.getLat().setScale(6, 6).toString();
        this.setCoordinates(lonLatString);
    }
}

