/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.rest.internal.classification;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.ClassificationRequestBuilder;
import org.opennms.netmgt.flows.classification.ClassificationService;
import org.opennms.netmgt.flows.classification.persistence.api.Group;
import org.opennms.netmgt.flows.classification.persistence.api.Protocols;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.rest.classification.ClassificationRequestDTO;
import org.opennms.netmgt.flows.rest.classification.ClassificationResponseDTO;
import org.opennms.netmgt.flows.rest.classification.ClassificationRestService;
import org.opennms.netmgt.flows.rest.classification.GroupDTO;
import org.opennms.netmgt.flows.rest.classification.RuleDTO;
import org.opennms.netmgt.flows.rest.internal.classification.ClassificationRequestDTOValidator;
import org.opennms.netmgt.flows.rest.internal.classification.FilenameHelper;
import org.opennms.web.utils.CriteriaBuilderUtils;
import org.opennms.web.utils.QueryParameters;
import org.opennms.web.utils.QueryParametersBuilder;
import org.opennms.web.utils.ResponseUtils;
import org.opennms.web.utils.UriInfoUtils;

public class ClassificationRestServiceImpl
implements ClassificationRestService {
    private final ClassificationService classificationService;

    public ClassificationRestServiceImpl(ClassificationService classificationService) {
        this.classificationService = Objects.requireNonNull(classificationService);
    }

    public Response getRules(UriInfo uriInfo) {
        QueryParameters.Order order;
        String rawQuery;
        QueryParameters queryParameters = QueryParametersBuilder.buildFrom((UriInfo)uriInfo);
        CriteriaBuilder criteriaBuilder = CriteriaBuilderUtils.buildFrom(Rule.class, (QueryParameters)queryParameters);
        criteriaBuilder.alias("group", "group");
        Set groupFilter = UriInfoUtils.getValues((UriInfo)uriInfo, (String)"groupFilter", Collections.emptyList()).stream().map(g -> g != null ? g.trim() : g).filter(g -> g != null).map(g -> Integer.valueOf(g)).collect(Collectors.toSet());
        if (!groupFilter.isEmpty()) {
            criteriaBuilder.in("group.id", groupFilter);
        }
        if ((rawQuery = UriInfoUtils.getValue((UriInfo)uriInfo, (String)"query", null)) != null && !rawQuery.trim().isEmpty()) {
            String query = "%" + rawQuery + "%";
            criteriaBuilder.or(new Restriction[]{Restrictions.iplike((String)"src_address", (Object)rawQuery), Restrictions.like((String)"srcAddress", (Object)query), Restrictions.ilike((String)"srcPort", (Object)query), Restrictions.iplike((String)"dst_address", (Object)rawQuery), Restrictions.like((String)"dstAddress", (Object)query), Restrictions.ilike((String)"dstPort", (Object)query), Restrictions.ilike((String)"name", (Object)query), Restrictions.ilike((String)"exporterFilter", (Object)query), Restrictions.ilike((String)"protocol", (Object)query)}).toCriteria();
        }
        if ((order = queryParameters.getOrder()) != null && order.getColumn() != null && order.getColumn().equalsIgnoreCase("position")) {
            criteriaBuilder.clearOrder();
            criteriaBuilder.orderBy("group.position", true);
            criteriaBuilder.orderBy(order.getColumn(), queryParameters.getOrder().isAsc());
        }
        criteriaBuilder.eq("group.enabled", (Object)true);
        return ClassificationRestServiceImpl.createResponse(criteriaBuilder, criteria -> this.classificationService.findMatchingRules(criteria), criteria -> this.classificationService.countMatchingRules(criteria), rules -> rules.stream().map(rule -> ClassificationRestServiceImpl.convert(rule)).collect(Collectors.toList()));
    }

    public Response getRule(int id) {
        Rule rule = this.classificationService.getRule(id);
        return Response.ok((Object)ClassificationRestServiceImpl.convert(rule)).build();
    }

    public Response saveRule(RuleDTO ruleDTO) {
        Rule rule = ClassificationRestServiceImpl.convert(ruleDTO);
        rule.setId(null);
        int ruleId = this.classificationService.saveRule(rule);
        UriBuilder builder = UriBuilder.fromResource(ClassificationRestService.class);
        URI uri = builder.path(ClassificationRestService.class, "getRule").build(new Object[]{ruleId});
        return Response.created((URI)uri).build();
    }

    public Response importRules(int groupId, UriInfo uriInfo, InputStream inputStream) {
        boolean skipHeader = Boolean.valueOf(UriInfoUtils.getValue((UriInfo)uriInfo, (String)"hasHeader", (String)"true"));
        boolean deleteExistingRules = Boolean.valueOf(UriInfoUtils.getValue((UriInfo)uriInfo, (String)"deleteExistingRules", (String)"true"));
        this.classificationService.importRules(groupId, inputStream, skipHeader, deleteExistingRules);
        return Response.noContent().build();
    }

    public Response deleteRules(UriInfo uriInfo) {
        String groupId = UriInfoUtils.getValue((UriInfo)uriInfo, (String)"groupId", null);
        if (groupId != null) {
            this.classificationService.deleteRules(Integer.parseInt(groupId));
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    public Response deleteRule(int id) {
        this.classificationService.deleteRule(id);
        return Response.noContent().build();
    }

    public Response updateRule(int id, RuleDTO newValue) {
        Integer newPosition;
        boolean groupChanged;
        Rule rule = this.classificationService.getRule(id);
        Rule newRule = ClassificationRestServiceImpl.convert(newValue);
        rule.setProtocol(newRule.getProtocol());
        rule.setDstPort(newRule.getDstPort());
        rule.setDstAddress(newRule.getDstAddress());
        rule.setSrcPort(newRule.getSrcPort());
        rule.setSrcAddress(newRule.getSrcAddress());
        rule.setName(newRule.getName());
        rule.setOmnidirectional(newRule.isOmnidirectional());
        rule.setExporterFilter(newValue.getExporterFilter());
        Group oldGroup = rule.getGroup();
        boolean bl = groupChanged = !oldGroup.getId().equals(newRule.getGroup().getId());
        if (groupChanged) {
            Group group = this.classificationService.getGroup(newRule.getGroup().getId().intValue());
            rule.setGroup(group);
        }
        if ((newPosition = newValue.getPosition()) != null) {
            int oldPosition = rule.getPosition();
            int newComputedPosition = newPosition > oldPosition ? newPosition + 1 : newPosition;
            rule.setPosition(newComputedPosition);
        }
        this.classificationService.updateRule(rule);
        if (groupChanged) {
            this.classificationService.updateGroup(oldGroup);
        }
        return Response.ok((Object)ClassificationRestServiceImpl.convert(rule)).build();
    }

    public Response classify(ClassificationRequestDTO classificationRequestDTO) {
        ClassificationRequestDTOValidator.validate(classificationRequestDTO);
        ClassificationRequest classificationRequest = new ClassificationRequestBuilder().withLocation(null).withSrcAddress(classificationRequestDTO.getSrcAddress()).withSrcPort(Integer.valueOf(Integer.parseInt(classificationRequestDTO.getSrcPort()))).withDstAddress(classificationRequestDTO.getDstAddress()).withDstPort(Integer.valueOf(Integer.parseInt(classificationRequestDTO.getDstPort()))).withProtocol(Protocols.getProtocol((String)classificationRequestDTO.getProtocol())).withExporterAddress(classificationRequestDTO.getExporterAddress()).build();
        String classification = this.classificationService.classify(classificationRequest);
        if (Strings.isNullOrEmpty((String)classification)) {
            return Response.noContent().build();
        }
        return Response.ok((Object)new ClassificationResponseDTO(classification)).build();
    }

    public Response getGroups(UriInfo uriInfo) {
        QueryParameters queryParameters = QueryParametersBuilder.buildFrom((UriInfo)uriInfo);
        CriteriaBuilder criteriaBuilder = CriteriaBuilderUtils.buildFrom(Group.class, (QueryParameters)queryParameters);
        return ClassificationRestServiceImpl.createResponse(criteriaBuilder, criteria -> this.classificationService.findMatchingGroups(criteria), criteria -> this.classificationService.countMatchingGroups(criteria), groups -> groups.stream().map(group -> ClassificationRestServiceImpl.convert(group)).collect(Collectors.toList()));
    }

    public Response getGroup(int groupId, String format, String requestedFilename, String acceptHeader) {
        boolean isCsvRequested;
        boolean bl = isCsvRequested = acceptHeader != null && acceptHeader.contains("text/comma-separated-values") || "csv".equalsIgnoreCase(format);
        if (isCsvRequested && requestedFilename != null && !new FilenameHelper().isValidFileName(requestedFilename)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"parameter filename should follow this regex pattern: ^[a-zA-Z1-9_ .-]{1,}$").build();
        }
        if (isCsvRequested) {
            return this.getGroupAsCsv(groupId, requestedFilename);
        }
        return this.getGroupAsJson(groupId);
    }

    private Response getGroupAsCsv(int groupId, String requestedFilename) {
        String csvContent = this.classificationService.exportRules(groupId);
        String filename = new FilenameHelper().createFilenameForGroupExport(groupId, requestedFilename);
        return Response.ok().header("Content-Disposition", (Object)("attachment; filename=\"" + filename + "\"")).header("Content-Type", (Object)"text/comma-separated-values").entity((Object)csvContent).build();
    }

    private Response getGroupAsJson(int groupId) {
        Group group = this.classificationService.getGroup(groupId);
        return Response.ok((Object)ClassificationRestServiceImpl.convert(group)).header("Content-Type", (Object)"application/json").build();
    }

    public Response saveGroup(GroupDTO groupDTO) {
        Group group = ClassificationRestServiceImpl.convert(groupDTO);
        group.setId(null);
        int groupId = this.classificationService.saveGroup(group);
        UriBuilder builder = UriBuilder.fromResource(ClassificationRestService.class);
        URI uri = builder.path(ClassificationRestService.class, "getGroup").build(new Object[]{groupId});
        return Response.created((URI)uri).build();
    }

    public Response deleteGroup(int groupId) {
        this.classificationService.deleteGroup(groupId);
        return Response.noContent().build();
    }

    public Response updateGroup(int id, GroupDTO groupDTO) {
        Group group = this.classificationService.getGroup(id);
        if (groupDTO.isEnabled() != null) {
            group.setEnabled(groupDTO.isEnabled().booleanValue());
        }
        if (!group.isReadOnly()) {
            Integer newPosition;
            if (!Strings.isNullOrEmpty((String)groupDTO.getName())) {
                group.setName(groupDTO.getName());
            }
            if (!Strings.isNullOrEmpty((String)groupDTO.getDescription())) {
                group.setDescription(groupDTO.getDescription());
            }
            if ((newPosition = groupDTO.getPosition()) != null) {
                int oldPosition = group.getPosition();
                int newComputedPosition = newPosition > oldPosition ? newPosition + 1 : newPosition;
                group.setPosition(newComputedPosition);
            }
        }
        this.classificationService.updateGroup(group);
        return Response.ok((Object)ClassificationRestServiceImpl.convert(group)).build();
    }

    public Response getProtocols() {
        return Response.ok((Object)Protocols.getProtocols()).build();
    }

    private static Rule convert(RuleDTO ruleDTO) {
        if (ruleDTO == null) {
            return null;
        }
        Rule rule = new Rule();
        rule.setPosition(ruleDTO.getPosition() == null ? Integer.MAX_VALUE : ruleDTO.getPosition());
        if (!Strings.isNullOrEmpty((String)ruleDTO.getName())) {
            rule.setName(ruleDTO.getName());
        }
        if (!Strings.isNullOrEmpty((String)ruleDTO.getDstAddress())) {
            rule.setDstAddress(ruleDTO.getDstAddress());
        }
        if (!Strings.isNullOrEmpty((String)ruleDTO.getDstPort())) {
            rule.setDstPort(ruleDTO.getDstPort());
        }
        if (!Strings.isNullOrEmpty((String)ruleDTO.getSrcAddress())) {
            rule.setSrcAddress(ruleDTO.getSrcAddress());
        }
        if (!Strings.isNullOrEmpty((String)ruleDTO.getSrcPort())) {
            rule.setSrcPort(ruleDTO.getSrcPort());
        }
        if (!Strings.isNullOrEmpty((String)ruleDTO.getExporterFilter())) {
            rule.setExporterFilter(ruleDTO.getExporterFilter());
        }
        rule.setOmnidirectional(ruleDTO.isOmnidirectional());
        rule.setProtocol(ruleDTO.getProtocols().stream().collect(Collectors.joining(",")));
        rule.setGroup(ClassificationRestServiceImpl.convert(ruleDTO.getGroup()));
        return rule;
    }

    private static RuleDTO convert(Rule rule) {
        if (rule == null) {
            return null;
        }
        RuleDTO ruleDTO = new RuleDTO();
        ruleDTO.setId(rule.getId());
        ruleDTO.setName(rule.getName());
        ruleDTO.setDstAddress(rule.getDstAddress());
        ruleDTO.setProtocol(rule.getProtocol());
        ruleDTO.setDstPort(rule.getDstPort());
        ruleDTO.setSrcAddress(rule.getSrcAddress());
        ruleDTO.setSrcPort(rule.getSrcPort());
        ruleDTO.setGroup(ClassificationRestServiceImpl.convert(rule.getGroup()));
        ruleDTO.setPosition(Integer.valueOf(rule.getPosition()));
        ruleDTO.setExporterFilter(rule.getExporterFilter());
        ruleDTO.setOmnidirectional(rule.isOmnidirectional());
        return ruleDTO;
    }

    private static GroupDTO convert(Group group) {
        if (group == null) {
            return null;
        }
        GroupDTO groupDTO = new GroupDTO();
        groupDTO.setId(group.getId());
        groupDTO.setName(group.getName());
        groupDTO.setDescription(group.getDescription());
        groupDTO.setPosition(Integer.valueOf(group.getPosition()));
        groupDTO.setEnabled(Boolean.valueOf(group.isEnabled()));
        groupDTO.setReadOnly(group.isReadOnly());
        groupDTO.setRuleCount(group.getRules().size());
        return groupDTO;
    }

    private static Group convert(GroupDTO groupDTO) {
        if (groupDTO == null) {
            return null;
        }
        Group group = new Group();
        group.setPosition(groupDTO.getPosition() == null ? Integer.MAX_VALUE : groupDTO.getPosition());
        group.setId(groupDTO.getId());
        if (!Strings.isNullOrEmpty((String)groupDTO.getName())) {
            group.setName(groupDTO.getName());
        }
        if (!Strings.isNullOrEmpty((String)groupDTO.getDescription())) {
            group.setDescription(groupDTO.getDescription());
        }
        if (groupDTO.isEnabled() != null) {
            group.setEnabled(groupDTO.isEnabled().booleanValue());
        }
        group.setReadOnly(false);
        return group;
    }

    private static <T, X> Response createResponse(CriteriaBuilder criteriaBuilder, MatchingDelegate<T> matchingDelegate, CountDelegate countDelegate, Function<List<T>, List<X>> transform) {
        Objects.requireNonNull(criteriaBuilder);
        Objects.requireNonNull(matchingDelegate);
        Objects.requireNonNull(countDelegate);
        Objects.requireNonNull(transform);
        Criteria criteria = criteriaBuilder.toCriteria();
        List<T> entities = matchingDelegate.findMatching(criteria);
        if (entities.isEmpty()) {
            return Response.noContent().build();
        }
        criteria.setOrders(new ArrayList());
        criteria.setOffset(null);
        criteria.setLimit(null);
        List<X> responseBody = transform.apply(entities);
        int offset = criteria.getOffset() == null ? 0 : criteria.getOffset();
        long totalCount = countDelegate.countMatching(criteria);
        return ResponseUtils.createResponse(responseBody, (long)offset, (long)totalCount);
    }

    @FunctionalInterface
    private static interface CountDelegate {
        public long countMatching(Criteria var1);
    }

    @FunctionalInterface
    private static interface MatchingDelegate<T> {
        public List<T> findMatching(Criteria var1);
    }
}

