/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.opennms.netmgt.flows.api.Conversation;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.FlowQueryService;
import org.opennms.netmgt.flows.api.Host;
import org.opennms.netmgt.flows.api.TrafficSummary;
import org.opennms.netmgt.flows.filter.api.Filter;
import org.opennms.netmgt.flows.filter.api.TimeRangeFilter;

public class SmartQueryService
implements FlowQueryService {
    private final FlowQueryService rawQueryService;
    private final FlowQueryService aggQueryService;
    private boolean alwaysUseAggForQueries = false;
    private boolean alwaysUseRawForQueries = true;
    private long timeRangeDurationAggregateThresholdMs = TimeUnit.MINUTES.toMillis(2L);
    private long timeRangeEndpointAggregateThresholdMs = TimeUnit.DAYS.toMillis(7L);
    private final Timer rawQuerySuccessTimer;
    private final Timer rawQueryFailureTimer;
    private final Timer aggregatedQuerySuccessTimer;
    private final Timer aggregatedQueryFailureTimer;

    public SmartQueryService(MetricRegistry metricRegistry, FlowQueryService rawQueryService, FlowQueryService aggQueryService) {
        this.rawQueryService = Objects.requireNonNull(rawQueryService);
        this.aggQueryService = Objects.requireNonNull(aggQueryService);
        this.rawQuerySuccessTimer = metricRegistry.timer("rawQuerySuccess");
        this.rawQueryFailureTimer = metricRegistry.timer("rawQueryFailure");
        this.aggregatedQuerySuccessTimer = metricRegistry.timer("aggregatedQuerySuccess");
        this.aggregatedQueryFailureTimer = metricRegistry.timer("aggregatedQueryFailure");
    }

    private QueryServiceType getDelegate(List<Filter> filters, boolean isQueryForSpecificEntities) {
        if (this.alwaysUseRawForQueries) {
            return QueryServiceType.RAW;
        }
        if (this.alwaysUseAggForQueries) {
            return QueryServiceType.AGG;
        }
        if (isQueryForSpecificEntities) {
            return QueryServiceType.RAW;
        }
        Optional timeRangeFilter = Filter.find(filters, TimeRangeFilter.class);
        if (!timeRangeFilter.isPresent()) {
            return QueryServiceType.RAW;
        }
        if (((TimeRangeFilter)timeRangeFilter.get()).getDurationMs() >= this.timeRangeDurationAggregateThresholdMs) {
            return QueryServiceType.AGG;
        }
        if (System.currentTimeMillis() - ((TimeRangeFilter)timeRangeFilter.get()).getEnd() > this.timeRangeEndpointAggregateThresholdMs) {
            return QueryServiceType.AGG;
        }
        return QueryServiceType.RAW;
    }

    private <T> CompletableFuture<T> runWithDelegate(List<Filter> filters, boolean isQueryForSpecificEntities, Function<FlowQueryService, CompletableFuture<T>> query) {
        QueryServiceType queryServiceType = this.getDelegate(filters, isQueryForSpecificEntities);
        switch (queryServiceType) {
            case AGG: {
                return SmartQueryService.timeAsync(this.aggregatedQuerySuccessTimer, this.aggregatedQueryFailureTimer, () -> (CompletableFuture)query.apply(this.aggQueryService));
            }
        }
        return SmartQueryService.timeAsync(this.rawQuerySuccessTimer, this.rawQueryFailureTimer, () -> (CompletableFuture)query.apply(this.rawQueryService));
    }

    public CompletableFuture<Long> getFlowCount(List<Filter> filters) {
        return this.runWithDelegate(filters, false, qs -> qs.getFlowCount(filters));
    }

    public CompletableFuture<List<String>> getApplications(String matchingPrefix, long limit, List<Filter> filters) {
        return this.runWithDelegate(filters, true, qs -> qs.getApplications(matchingPrefix, limit, filters));
    }

    public CompletableFuture<List<TrafficSummary<String>>> getTopNApplicationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, false, qs -> qs.getTopNApplicationSummaries(N, includeOther, filters));
    }

    public CompletableFuture<List<TrafficSummary<String>>> getApplicationSummaries(Set<String> applications, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, true, qs -> qs.getApplicationSummaries(applications, includeOther, filters));
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getApplicationSeries(Set<String> applications, long step, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, true, qs -> qs.getApplicationSeries(applications, step, includeOther, filters));
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getTopNApplicationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, false, qs -> qs.getTopNApplicationSeries(N, step, includeOther, filters));
    }

    public CompletableFuture<List<String>> getConversations(String locationPattern, String protocolPattern, String lowerIPPattern, String upperIPPattern, String applicationPattern, long limit, List<Filter> filters) {
        return this.runWithDelegate(filters, true, qs -> qs.getConversations(locationPattern, protocolPattern, lowerIPPattern, upperIPPattern, applicationPattern, limit, filters));
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getTopNConversationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, false, qs -> qs.getTopNConversationSummaries(N, includeOther, filters));
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getConversationSummaries(Set<String> conversations, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, true, qs -> qs.getConversationSummaries(conversations, includeOther, filters));
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getConversationSeries(Set<String> conversations, long step, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, true, qs -> qs.getConversationSeries(conversations, step, includeOther, filters));
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getTopNConversationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, false, qs -> qs.getTopNConversationSeries(N, step, includeOther, filters));
    }

    public CompletableFuture<List<String>> getHosts(String regex, long limit, List<Filter> filters) {
        return this.runWithDelegate(filters, true, qs -> qs.getHosts(regex, limit, filters));
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getTopNHostSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, false, qs -> qs.getTopNHostSummaries(N, includeOther, filters));
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getHostSummaries(Set<String> hosts, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, true, qs -> qs.getHostSummaries(hosts, includeOther, filters));
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getHostSeries(Set<String> hosts, long step, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, true, qs -> qs.getHostSeries(hosts, step, includeOther, filters));
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getTopNHostSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.runWithDelegate(filters, false, qs -> qs.getTopNHostSeries(N, step, includeOther, filters));
    }

    public boolean isAlwaysUseAggForQueries() {
        return this.alwaysUseAggForQueries;
    }

    public void setAlwaysUseAggForQueries(boolean alwaysUseAggForQueries) {
        this.alwaysUseAggForQueries = alwaysUseAggForQueries;
        if (alwaysUseAggForQueries) {
            this.alwaysUseRawForQueries = false;
        }
    }

    public boolean isAlwaysUseRawForQueries() {
        return this.alwaysUseRawForQueries;
    }

    public void setAlwaysUseRawForQueries(boolean alwaysUseRawForQueries) {
        this.alwaysUseRawForQueries = alwaysUseRawForQueries;
        if (alwaysUseRawForQueries) {
            this.alwaysUseAggForQueries = false;
        }
    }

    public long getTimeRangeDurationAggregateThresholdMs() {
        return this.timeRangeDurationAggregateThresholdMs;
    }

    public void setTimeRangeDurationAggregateThresholdMs(long timeRangeDurationAggregateThresholdMs) {
        this.timeRangeDurationAggregateThresholdMs = timeRangeDurationAggregateThresholdMs;
    }

    public long getTimeRangeEndpointAggregateThresholdMs() {
        return this.timeRangeEndpointAggregateThresholdMs;
    }

    public void setTimeRangeEndpointAggregateThresholdMs(long timeRangeEndpointAggregateThresholdMs) {
        this.timeRangeEndpointAggregateThresholdMs = timeRangeEndpointAggregateThresholdMs;
    }

    public String toString() {
        return "SmartQueryService{alwaysUseAggForQueries=" + this.alwaysUseAggForQueries + ", alwaysUseRawForQueries=" + this.alwaysUseRawForQueries + ", timeRangeDurationAggregateThresholdMs=" + this.timeRangeDurationAggregateThresholdMs + ", timeRangeEndpointAggregateThresholdMs=" + this.timeRangeEndpointAggregateThresholdMs + '}';
    }

    private static <T> CompletableFuture<T> timeAsync(Timer successTimer, Timer failureTimer, Callable<CompletableFuture<T>> operation) {
        Timer.Context successContext = successTimer.time();
        Timer.Context failureContext = failureTimer.time();
        try {
            CompletableFuture promise = new CompletableFuture();
            CompletableFuture<T> future = operation.call();
            future.handleAsync((success, failure) -> {
                if (failure == null) {
                    successContext.stop();
                    promise.complete(success);
                } else {
                    failureContext.stop();
                    promise.completeExceptionally((Throwable)failure);
                }
                return null;
            });
            return promise;
        }
        catch (Exception ex) {
            failureContext.stop();
            throw new RuntimeException(ex);
        }
    }

    public static enum QueryServiceType {
        RAW,
        AGG;

    }
}

