/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.opennms.features.jest.client.index.IndexSelector;
import org.opennms.netmgt.flows.api.FlowQueryService;
import org.opennms.netmgt.flows.filter.api.TimeRangeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticFlowQueryService
implements FlowQueryService {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticFlowQueryService.class);
    private final JestClient client;
    private final IndexSelector indexSelector;

    public ElasticFlowQueryService(JestClient client, IndexSelector indexSelector) {
        this.client = Objects.requireNonNull(client);
        this.indexSelector = Objects.requireNonNull(indexSelector);
    }

    public CompletableFuture<SearchResult> searchAsync(String query, TimeRangeFilter timeRangeFilter) {
        Search.Builder builder = new Search.Builder(query);
        if (timeRangeFilter != null) {
            List indices = this.indexSelector.getIndexNames(timeRangeFilter.getStart(), timeRangeFilter.getEnd());
            builder.addIndices((Collection)indices);
            builder.setParameter("ignore_unavailable", (Object)"true");
            LOG.debug("Executing asynchronous query on {}: {}", (Object)indices, (Object)query);
        } else {
            LOG.debug("Executing asynchronous query on all indices: {}", (Object)query);
        }
        return this.executeAsync((Action)builder.build());
    }

    public <T extends JestResult> CompletableFuture<T> executeAsync(Action<T> action) {
        final CompletableFuture future = new CompletableFuture();
        this.client.executeAsync(action, new JestResultHandler<T>(){

            public void completed(T result) {
                if (!result.isSucceeded()) {
                    future.completeExceptionally(new Exception(result.getErrorMessage()));
                } else {
                    future.complete(result);
                }
            }

            public void failed(Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }
}

