/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic.template;

import java.io.IOException;
import org.junit.Test;
import org.opennms.core.test.xml.JsonTest;
import org.opennms.features.jest.client.template.DefaultTemplateLoader;
import org.opennms.features.jest.client.template.IndexSettings;
import org.opennms.features.jest.client.template.MergingTemplateLoader;
import org.opennms.features.jest.client.template.TemplateLoader;
import org.opennms.features.jest.client.template.Version;

public class MergingTemplateLoaderTest {
    private static final Version version = new Version(7, 2, 0);

    @Test
    public void verifyMergingEmpty() throws IOException {
        String merged = new MergingTemplateLoader((TemplateLoader)new DefaultTemplateLoader(), new IndexSettings()).load(version, "/netflow-template");
        String expected = new DefaultTemplateLoader().load(version, "/netflow-template");
        JsonTest.assertJsonEquals((String)expected, (String)merged);
    }

    @Test
    public void verifyMergingFull() throws IOException {
        IndexSettings IndexSettings2 = new IndexSettings();
        IndexSettings2.setNumberOfReplicas(Integer.valueOf(10));
        IndexSettings2.setNumberOfShards(Integer.valueOf(20));
        IndexSettings2.setRefreshInterval("60s");
        IndexSettings2.setRoutingPartitionSize(Integer.valueOf(100));
        String merged = new MergingTemplateLoader((TemplateLoader)new DefaultTemplateLoader(), IndexSettings2).load(version, "/netflow-template");
        String expected = new DefaultTemplateLoader().load(version, "/netflow-template-merged");
        JsonTest.assertJsonEquals((String)expected, (String)merged);
    }
}

