/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import java.util.Optional;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.elastic.FlowDocument;

public class TestFlow
implements Flow {
    final FlowDocument flowDocument;
    String nodeIdentifier;

    public TestFlow(FlowDocument flowDocument) {
        this.flowDocument = flowDocument;
    }

    public long getTimestamp() {
        return this.flowDocument.getTimestamp();
    }

    public Long getBytes() {
        return this.flowDocument.getBytes();
    }

    public Flow.Direction getDirection() {
        if (this.flowDocument.getDirection() == null) {
            return Flow.Direction.INGRESS;
        }
        switch (this.flowDocument.getDirection()) {
            case INGRESS: {
                return Flow.Direction.INGRESS;
            }
            case EGRESS: {
                return Flow.Direction.EGRESS;
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + this.flowDocument.getDirection().name());
    }

    public String getDstAddr() {
        return this.flowDocument.getDstAddr();
    }

    public Optional<String> getDstAddrHostname() {
        return Optional.ofNullable(this.flowDocument.getDstAddrHostname());
    }

    public Long getDstAs() {
        return this.flowDocument.getDstAs();
    }

    public Integer getDstMaskLen() {
        return this.flowDocument.getDstMaskLen();
    }

    public Integer getDstPort() {
        return this.flowDocument.getDstPort();
    }

    public Integer getEngineId() {
        return this.flowDocument.getEngineId();
    }

    public Integer getEngineType() {
        return this.flowDocument.getEngineType();
    }

    public Long getDeltaSwitched() {
        return this.flowDocument.getDeltaSwitched();
    }

    public Long getFirstSwitched() {
        return this.flowDocument.getFirstSwitched();
    }

    public int getFlowRecords() {
        return this.flowDocument.getFlowRecords();
    }

    public long getFlowSeqNum() {
        return this.flowDocument.getFlowSeqNum();
    }

    public Integer getInputSnmp() {
        return this.flowDocument.getInputSnmp();
    }

    public Integer getIpProtocolVersion() {
        return this.flowDocument.getIpProtocolVersion();
    }

    public Long getLastSwitched() {
        return this.flowDocument.getLastSwitched();
    }

    public String getNextHop() {
        return this.flowDocument.getNextHop();
    }

    public Optional<String> getNextHopHostname() {
        return Optional.ofNullable(this.flowDocument.getNextHopHostname());
    }

    public Integer getOutputSnmp() {
        return this.flowDocument.getOutputSnmp();
    }

    public Long getPackets() {
        return this.flowDocument.getPackets();
    }

    public Integer getProtocol() {
        return this.flowDocument.getProtocol();
    }

    public Flow.SamplingAlgorithm getSamplingAlgorithm() {
        if (this.flowDocument.getSamplingAlgorithm() == null) {
            return null;
        }
        switch (this.flowDocument.getSamplingAlgorithm()) {
            case Unassigned: {
                return Flow.SamplingAlgorithm.Unassigned;
            }
            case SystematicCountBasedSampling: {
                return Flow.SamplingAlgorithm.SystematicCountBasedSampling;
            }
            case SystematicTimeBasedSampling: {
                return Flow.SamplingAlgorithm.SystematicTimeBasedSampling;
            }
            case RandomNoutOfNSampling: {
                return Flow.SamplingAlgorithm.RandomNoutOfNSampling;
            }
            case UniformProbabilisticSampling: {
                return Flow.SamplingAlgorithm.UniformProbabilisticSampling;
            }
            case PropertyMatchFiltering: {
                return Flow.SamplingAlgorithm.PropertyMatchFiltering;
            }
            case HashBasedFiltering: {
                return Flow.SamplingAlgorithm.HashBasedFiltering;
            }
            case FlowStateDependentIntermediateFlowSelectionProcess: {
                return Flow.SamplingAlgorithm.FlowStateDependentIntermediateFlowSelectionProcess;
            }
        }
        throw new IllegalArgumentException("Unknown sampling algorithm: " + this.flowDocument.getSamplingAlgorithm().name());
    }

    public Double getSamplingInterval() {
        return this.flowDocument.getSamplingInterval();
    }

    public String getSrcAddr() {
        return this.flowDocument.getSrcAddr();
    }

    public Optional<String> getSrcAddrHostname() {
        return Optional.ofNullable(this.flowDocument.getSrcAddrHostname());
    }

    public Long getSrcAs() {
        return this.flowDocument.getSrcAs();
    }

    public Integer getSrcMaskLen() {
        return this.flowDocument.getSrcMaskLen();
    }

    public Integer getSrcPort() {
        return this.flowDocument.getSrcPort();
    }

    public Integer getTcpFlags() {
        return this.flowDocument.getTcpFlags();
    }

    public Integer getTos() {
        return this.flowDocument.getTos();
    }

    public Flow.NetflowVersion getNetflowVersion() {
        if (this.flowDocument.getNetflowVersion() == null) {
            return null;
        }
        switch (this.flowDocument.getNetflowVersion()) {
            case V5: {
                return Flow.NetflowVersion.V5;
            }
            case V9: {
                return Flow.NetflowVersion.V9;
            }
            case IPFIX: {
                return Flow.NetflowVersion.IPFIX;
            }
            case SFLOW: {
                return Flow.NetflowVersion.SFLOW;
            }
        }
        throw new IllegalArgumentException("Unknown protocol version: " + this.flowDocument.getNetflowVersion().name());
    }

    public Integer getVlan() {
        return this.flowDocument.getVlan() == null ? null : Integer.valueOf(this.flowDocument.getVlan());
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(String nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }
}

