/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.elastic.TableUtils;

public class TableUtilsTest {
    @Test
    public void canSortEmptyTable() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        ImmutableTable emptyTable = builder.build();
        MatcherAssert.assertThat((Object)TableUtils.sortTableByRowKeys((Table)emptyTable, Collections.emptyList()), (Matcher)Matchers.equalTo((Object)emptyTable));
    }

    @Test
    public void canSortTable() {
        ImmutableTable.Builder unsortedBuilder = ImmutableTable.builder();
        unsortedBuilder.put((Object)new Directional((Object)"c", false), (Object)1L, (Object)1.0);
        unsortedBuilder.put((Object)new Directional((Object)"a", false), (Object)1L, (Object)1.0);
        unsortedBuilder.put((Object)new Directional((Object)"d", false), (Object)1L, (Object)1.0);
        unsortedBuilder.put((Object)new Directional((Object)"b", false), (Object)1L, (Object)1.0);
        unsortedBuilder.put((Object)new Directional((Object)"e", false), (Object)1L, (Object)1.0);
        ImmutableTable unsortedTable = unsortedBuilder.build();
        List<String> keysAfterSort = TableUtilsTest.getRowKeys((Table<Directional<String>, Long, Double>)TableUtils.sortTableByRowKeys((Table)unsortedTable, Arrays.asList("a", "b", "c", "z")));
        MatcherAssert.assertThat(keysAfterSort, (Matcher)Matchers.equalTo(Arrays.asList("a", "b", "c", "d", "e")));
    }

    private static List<String> getRowKeys(Table<Directional<String>, Long, Double> table) {
        return table.rowKeySet().stream().map(Directional::getValue).collect(Collectors.toList());
    }
}

