/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.internal.util.reflection.Whitebox;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.elastic.SamplingAlgorithm;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class SamplingAlgorithmTest {
    @Test
    public void canMapAllValues() {
        for (Flow.SamplingAlgorithm samplingAlgorithm : Flow.SamplingAlgorithm.values()) {
            MatcherAssert.assertThat((Object)SamplingAlgorithm.from((Flow.SamplingAlgorithm)samplingAlgorithm), (Matcher)Matchers.notNullValue());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    @PrepareForTest(value={Flow.SamplingAlgorithm.class})
    public void willThrowExceptionOnIllegalValue() {
        Flow.SamplingAlgorithm illegalValue = (Flow.SamplingAlgorithm)PowerMockito.mock(Flow.SamplingAlgorithm.class);
        Whitebox.setInternalState((Object)illegalValue, (String)"name", (Object)"illegalValue");
        Whitebox.setInternalState((Object)illegalValue, (String)"ordinal", (Object)8);
        PowerMockito.mockStatic(Flow.SamplingAlgorithm.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Flow.SamplingAlgorithm.values()).thenReturn((Object)new Flow.SamplingAlgorithm[]{Flow.SamplingAlgorithm.Unassigned, Flow.SamplingAlgorithm.SystematicCountBasedSampling, Flow.SamplingAlgorithm.SystematicTimeBasedSampling, Flow.SamplingAlgorithm.RandomNoutOfNSampling, Flow.SamplingAlgorithm.UniformProbabilisticSampling, Flow.SamplingAlgorithm.PropertyMatchFiltering, Flow.SamplingAlgorithm.HashBasedFiltering, Flow.SamplingAlgorithm.FlowStateDependentIntermediateFlowSelectionProcess, illegalValue});
        SamplingAlgorithm.from((Flow.SamplingAlgorithm)illegalValue);
    }
}

