/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockito.Mockito;
import org.opennms.core.cache.CacheConfigBuilder;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.dao.mock.MockAssetRecordDao;
import org.opennms.netmgt.dao.mock.MockCategoryDao;
import org.opennms.netmgt.dao.mock.MockInterfaceToNodeCache;
import org.opennms.netmgt.dao.mock.MockNodeDao;
import org.opennms.netmgt.dao.mock.MockSessionUtils;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.internal.DefaultClassificationEngine;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.classification.persistence.api.RuleBuilder;
import org.opennms.netmgt.flows.elastic.DocumentEnricher;

public class MockDocumentEnricherFactory {
    private final NodeDao nodeDao;
    private final InterfaceToNodeCache interfaceToNodeCache;
    private final MockAssetRecordDao assetRecordDao;
    private final MockCategoryDao categoryDao;
    private final DocumentEnricher enricher;
    private final ClassificationEngine classificationEngine;
    private final AtomicInteger nodeDaoGetCounter = new AtomicInteger(0);

    public MockDocumentEnricherFactory() {
        this.nodeDao = this.createNodeDao();
        this.interfaceToNodeCache = new MockInterfaceToNodeCache();
        this.assetRecordDao = new MockAssetRecordDao();
        this.categoryDao = new MockCategoryDao();
        this.classificationEngine = new DefaultClassificationEngine(() -> Lists.newArrayList((Object[])new Rule[]{new RuleBuilder().withName("http").withDstPort("80").withProtocol("tcp,udp").build(), new RuleBuilder().withName("https").withDstPort("443").withProtocol("tcp,udp").build(), new RuleBuilder().withName("http").withSrcPort("80").withProtocol("tcp,udp").build(), new RuleBuilder().withName("https").withSrcPort("443").withProtocol("tcp,udp").build()}), FilterService.NOOP);
        this.enricher = new DocumentEnricher(new MetricRegistry(), this.nodeDao, this.interfaceToNodeCache, (SessionUtils)new MockSessionUtils(), this.classificationEngine, new CacheConfigBuilder().withName("flows.node").withMaximumSize(1000L).withExpireAfterWrite(300L).build());
        this.addServiceRegistry((OnmsDao)this.nodeDao);
        this.addServiceRegistry((OnmsDao)this.assetRecordDao);
        this.addServiceRegistry((OnmsDao)this.categoryDao);
        DefaultServiceRegistry.INSTANCE.register((Object)this.nodeDao, new Class[]{NodeDao.class});
        DefaultServiceRegistry.INSTANCE.register((Object)this.assetRecordDao, new Class[]{AssetRecordDao.class});
        DefaultServiceRegistry.INSTANCE.register((Object)this.categoryDao, new Class[]{CategoryDao.class});
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public InterfaceToNodeCache getInterfaceToNodeCache() {
        return this.interfaceToNodeCache;
    }

    public DocumentEnricher getEnricher() {
        return this.enricher;
    }

    public AtomicInteger getNodeDaoGetCounter() {
        return this.nodeDaoGetCounter;
    }

    public ClassificationEngine getClassificationEngine() {
        return this.classificationEngine;
    }

    private NodeDao createNodeDao() {
        MockNodeDao dao = new MockNodeDao();
        NodeDao spyMock = (NodeDao)Mockito.spy((Object)dao);
        Mockito.when((Object)spyMock.get((Serializable)Integer.valueOf(Mockito.anyInt()))).then(invocationOnMock -> {
            this.nodeDaoGetCounter.incrementAndGet();
            return dao.get((Serializable)((Integer)invocationOnMock.getArguments()[0]));
        });
        return spyMock;
    }

    private void addServiceRegistry(OnmsDao dao) {
        try {
            Field field = AbstractMockDao.class.getDeclaredField("m_serviceRegistry");
            field.setAccessible(true);
            field.set(dao, DefaultServiceRegistry.INSTANCE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

