/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opennms.core.test.xml.JsonTest;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.flows.elastic.DocumentEnricher;
import org.opennms.netmgt.flows.elastic.MockDocumentEnricherFactory;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;

public class FlowDocumentTest {
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
    private DocumentEnricher enricher;

    @Before
    public void setUp() {
        MockDocumentEnricherFactory factory = new MockDocumentEnricherFactory();
        this.enricher = factory.getEnricher();
        NodeDao nodeDao = factory.getNodeDao();
        InterfaceToNodeCache interfaceToNodeCache = factory.getInterfaceToNodeCache();
        interfaceToNodeCache.setNodeId("SomeLocation", InetAddressUtils.addr((String)"192.168.1.2"), 1);
        interfaceToNodeCache.setNodeId("SomeLocation", InetAddressUtils.addr((String)"192.168.2.2"), 2);
        interfaceToNodeCache.setNodeId("SomeLocation", InetAddressUtils.addr((String)"192.168.1.1"), 3);
        nodeDao.save((Object)FlowDocumentTest.createOnmsNode(1, "SomeRequisition"));
        nodeDao.save((Object)FlowDocumentTest.createOnmsNode(2, "SomeRequisition"));
        nodeDao.save((Object)FlowDocumentTest.createOnmsNode(3, "SomeRequisition"));
    }

    @Test
    public void verifyEffectiveDocument() throws IOException {
        List documents = this.enricher.enrich(Collections.singletonList(FlowDocumentTest.getMockFlow()), FlowDocumentTest.getMockFlowSource());
        MatcherAssert.assertThat((Object)documents, (Matcher)Matchers.hasSize((int)1));
        String actualJson = this.gson.toJson(documents.get(0));
        String expectedJson = Resources.toString((URL)Resources.getResource((String)"flow-document-netflow5.json"), (Charset)StandardCharsets.UTF_8);
        JsonTest.assertJsonEquals((String)expectedJson, (String)actualJson);
    }

    public static Flow getMockFlow() {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getNetflowVersion()).thenReturn((Object)Flow.NetflowVersion.V5);
        Mockito.when((Object)flow.getDirection()).thenReturn((Object)Flow.Direction.INGRESS);
        Mockito.when((Object)flow.getIpProtocolVersion()).thenReturn((Object)4);
        Mockito.when((Object)flow.getSrcAddr()).thenReturn((Object)"192.168.1.2");
        Mockito.when((Object)flow.getSrcAddrHostname()).thenReturn(Optional.empty());
        Mockito.when((Object)flow.getDstAddr()).thenReturn((Object)"192.168.2.2");
        Mockito.when((Object)flow.getDstAddrHostname()).thenReturn(Optional.of("four.three.two.one"));
        Mockito.when((Object)flow.getNextHopHostname()).thenReturn(Optional.empty());
        Mockito.when((Object)flow.getVlan()).thenReturn(null);
        return flow;
    }

    public static FlowSource getMockFlowSource() {
        FlowSource flowSource = (FlowSource)Mockito.mock(FlowSource.class);
        Mockito.when((Object)flowSource.getLocation()).thenReturn((Object)"SomeLocation");
        Mockito.when((Object)flowSource.getSourceAddress()).thenReturn((Object)"192.168.1.1");
        return flowSource;
    }

    private static OnmsNode createOnmsNode(int nodeId, String foreignSource) {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        node.setForeignSource(foreignSource);
        node.setForeignId(nodeId + "");
        OnmsCategory category = new OnmsCategory();
        category.setName("SomeCategory");
        node.setCategories((Set)Sets.newHashSet((Object[])new OnmsCategory[]{category}));
        return node;
    }
}

