/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.elastic.Direction;
import org.opennms.netmgt.flows.elastic.DocumentEnricher;
import org.opennms.netmgt.flows.elastic.FlowDocument;
import org.opennms.netmgt.flows.elastic.MockDocumentEnricherFactory;
import org.opennms.netmgt.flows.elastic.TestFlow;
import org.opennms.netmgt.model.OnmsNode;

public class DocumentEnricherTest {
    private DocumentEnricher enricher;
    private AtomicInteger nodeDaoGetCounter;
    private InterfaceToNodeCache interfaceToNodeCache;

    @Before
    public void setUp() {
        MockDocumentEnricherFactory factory = new MockDocumentEnricherFactory();
        this.enricher = factory.getEnricher();
        NodeDao nodeDao = factory.getNodeDao();
        this.interfaceToNodeCache = factory.getInterfaceToNodeCache();
        this.nodeDaoGetCounter = factory.getNodeDaoGetCounter();
        this.interfaceToNodeCache.setNodeId("Default", InetAddressUtils.addr((String)"10.0.0.1"), 1);
        this.interfaceToNodeCache.setNodeId("Default", InetAddressUtils.addr((String)"10.0.0.2"), 2);
        this.interfaceToNodeCache.setNodeId("Default", InetAddressUtils.addr((String)"10.0.0.3"), 3);
        nodeDao.save((Object)DocumentEnricherTest.createOnmsNode(1, "my-requisition"));
        nodeDao.save((Object)DocumentEnricherTest.createOnmsNode(2, "my-requisition"));
        nodeDao.save((Object)DocumentEnricherTest.createOnmsNode(3, "my-requisition"));
    }

    @Test
    public void verifyCacheUsage() {
        ArrayList documents = Lists.newArrayList();
        documents.add(DocumentEnricherTest.createFlowDocument("10.0.0.1", "10.0.0.2"));
        documents.add(DocumentEnricherTest.createFlowDocument("10.0.0.1", "10.0.0.3"));
        this.enricher.enrich((Collection)documents.stream().map(TestFlow::new).collect(Collectors.toList()), new FlowSource("Default", "127.0.0.1", null));
        Assert.assertEquals((long)6L, (long)this.nodeDaoGetCounter.get());
        documents.clear();
        documents.add(DocumentEnricherTest.createFlowDocument("10.0.0.2", "10.0.0.3"));
        this.enricher.enrich((Collection)documents.stream().map(TestFlow::new).collect(Collectors.toList()), new FlowSource("Default", "127.0.0.1", null));
        Assert.assertEquals((long)6L, (long)this.nodeDaoGetCounter.get());
        this.interfaceToNodeCache.setNodeId("Default", InetAddressUtils.addr((String)"10.0.0.4"), 2);
        this.interfaceToNodeCache.setNodeId("Default", InetAddressUtils.addr((String)"10.0.0.5"), 3);
        documents.add(DocumentEnricherTest.createFlowDocument("10.0.0.4", "10.0.0.5"));
        this.enricher.enrich((Collection)documents.stream().map(TestFlow::new).collect(Collectors.toList()), new FlowSource("Default", "127.0.0.1", null));
        Assert.assertEquals((long)6L, (long)this.nodeDaoGetCounter.get());
    }

    private static FlowDocument createFlowDocument(String sourceIp, String destIp) {
        FlowDocument document = new FlowDocument();
        document.setSrcAddr(sourceIp);
        document.setSrcPort(Integer.valueOf(510));
        document.setDstAddr(destIp);
        document.setDstPort(Integer.valueOf(80));
        document.setProtocol(Integer.valueOf(6));
        return document;
    }

    private static OnmsNode createOnmsNode(int nodeId, String foreignSource) {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        node.setForeignSource(foreignSource);
        node.setForeignId(nodeId + "");
        return node;
    }

    @Test
    public void testCreateClassificationRequest() {
        FlowDocument flowDocument = new FlowDocument();
        ClassificationRequest classificationRequest = DocumentEnricher.createClassificationRequest((FlowDocument)flowDocument);
        Assert.assertEquals((Object)false, (Object)classificationRequest.isClassifiable());
        flowDocument.setDstPort(Integer.valueOf(123));
        classificationRequest = DocumentEnricher.createClassificationRequest((FlowDocument)flowDocument);
        Assert.assertEquals((Object)false, (Object)classificationRequest.isClassifiable());
        flowDocument.setSrcPort(Integer.valueOf(456));
        classificationRequest = DocumentEnricher.createClassificationRequest((FlowDocument)flowDocument);
        Assert.assertEquals((Object)false, (Object)classificationRequest.isClassifiable());
        flowDocument.setProtocol(Integer.valueOf(6));
        classificationRequest = DocumentEnricher.createClassificationRequest((FlowDocument)flowDocument);
        Assert.assertEquals((Object)true, (Object)classificationRequest.isClassifiable());
    }

    @Test
    public void testDirection() {
        FlowDocument d1 = new FlowDocument();
        d1.setSrcAddr("1.1.1.1");
        d1.setSrcPort(Integer.valueOf(1));
        d1.setDstAddr("2.2.2.2");
        d1.setDstPort(Integer.valueOf(2));
        d1.setProtocol(Integer.valueOf(6));
        d1.setDirection(Direction.INGRESS);
        ClassificationRequest c1 = DocumentEnricher.createClassificationRequest((FlowDocument)d1);
        Assert.assertEquals((Object)"1.1.1.1", (Object)c1.getSrcAddress());
        Assert.assertEquals((Object)"2.2.2.2", (Object)c1.getDstAddress());
        Assert.assertEquals((Object)new Integer(1), (Object)c1.getSrcPort());
        Assert.assertEquals((Object)new Integer(2), (Object)c1.getDstPort());
        FlowDocument d2 = new FlowDocument();
        d2.setSrcAddr("1.1.1.1");
        d2.setSrcPort(Integer.valueOf(1));
        d2.setDstAddr("2.2.2.2");
        d2.setDstPort(Integer.valueOf(2));
        d2.setProtocol(Integer.valueOf(6));
        d2.setDirection(Direction.EGRESS);
        ClassificationRequest c2 = DocumentEnricher.createClassificationRequest((FlowDocument)d2);
        Assert.assertEquals((Object)"1.1.1.1", (Object)c2.getSrcAddress());
        Assert.assertEquals((Object)"2.2.2.2", (Object)c2.getDstAddress());
        Assert.assertEquals((Object)new Integer(1), (Object)c2.getSrcPort());
        Assert.assertEquals((Object)new Integer(2), (Object)c2.getDstPort());
        FlowDocument d3 = new FlowDocument();
        d3.setSrcAddr("1.1.1.1");
        d3.setSrcPort(Integer.valueOf(1));
        d3.setDstAddr("2.2.2.2");
        d3.setDstPort(Integer.valueOf(2));
        d3.setProtocol(Integer.valueOf(6));
        d3.setDirection(null);
        ClassificationRequest c3 = DocumentEnricher.createClassificationRequest((FlowDocument)d3);
        Assert.assertEquals((Object)"1.1.1.1", (Object)c3.getSrcAddress());
        Assert.assertEquals((Object)"2.2.2.2", (Object)c3.getDstAddress());
        Assert.assertEquals((Object)new Integer(1), (Object)c3.getSrcPort());
        Assert.assertEquals((Object)new Integer(2), (Object)c3.getDstPort());
    }
}

