/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.opennms.netmgt.flows.api.ConversationKey;
import org.opennms.netmgt.flows.elastic.ConversationKeyUtils;
import org.opennms.netmgt.flows.elastic.Direction;
import org.opennms.netmgt.flows.elastic.FlowDocument;

public class ConversationKeyUtilsTest {
    @Test
    public void canCreateAndParseConversationKey() {
        FlowDocument flowIn = new FlowDocument();
        flowIn.setDirection(Direction.INGRESS);
        flowIn.setLocation("SomeLoc");
        flowIn.setProtocol(Integer.valueOf(1));
        flowIn.setSrcAddr("1.1.1.1");
        flowIn.setDstAddr("2.2.2.2");
        flowIn.setApplication("ulf");
        FlowDocument flowOut = new FlowDocument();
        flowOut.setDirection(Direction.EGRESS);
        flowOut.setLocation(flowIn.getLocation());
        flowOut.setProtocol(flowIn.getProtocol());
        flowOut.setSrcAddr(flowIn.getDstAddr());
        flowOut.setDstAddr(flowIn.getSrcAddr());
        flowOut.setApplication(flowIn.getApplication());
        String inKey = ConversationKeyUtils.getConvoKeyAsJsonString((FlowDocument)flowIn);
        String outKey = ConversationKeyUtils.getConvoKeyAsJsonString((FlowDocument)flowOut);
        MatcherAssert.assertThat((Object)inKey, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inKey, (Matcher)Matchers.equalTo((Object)outKey));
        ConversationKey expectedKey = new ConversationKey(flowIn.getLocation(), flowIn.getProtocol(), flowIn.getSrcAddr(), flowIn.getDstAddr(), flowIn.getApplication());
        ConversationKey actualKey = ConversationKeyUtils.fromJsonString((String)inKey);
        MatcherAssert.assertThat((Object)actualKey, (Matcher)Matchers.equalTo((Object)expectedKey));
    }
}

