/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd.jmx;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapdInstrumentation {
    private static final Logger LOG = LoggerFactory.getLogger(TrapdInstrumentation.class);
    private long trapsReceived = 0L;
    private long v1TrapsReceived = 0L;
    private long v2cTrapsReceived = 0L;
    private long v3TrapsReceived = 0L;
    private long vUnknownTrapsReceived = 0L;
    private long trapsDiscarded = 0L;
    private long trapsErrored = 0L;

    public synchronized void incTrapsReceivedCount(String version) {
        ++this.trapsReceived;
        if ("v1".equals(version)) {
            ++this.v1TrapsReceived;
        } else if ("v2c".equals(version) || "v2".equals(version)) {
            ++this.v2cTrapsReceived;
        } else if ("v3".equals(version)) {
            ++this.v3TrapsReceived;
        } else {
            ++this.vUnknownTrapsReceived;
            LOG.warn("Received a trap with an unknown SNMP protocol version '{}'", (Object)version);
        }
    }

    public synchronized void incDiscardCount() {
        ++this.trapsDiscarded;
    }

    public synchronized void incErrorCount() {
        ++this.trapsErrored;
    }

    public long getV1TrapsReceived() {
        return this.v1TrapsReceived;
    }

    public long getV2cTrapsReceived() {
        return this.v2cTrapsReceived;
    }

    public long getV3TrapsReceived() {
        return this.v3TrapsReceived;
    }

    public long getVUnknownTrapsReceived() {
        return this.vUnknownTrapsReceived;
    }

    public long getTrapsDiscarded() {
        return this.trapsDiscarded;
    }

    public long getTrapsErrored() {
        return this.trapsErrored;
    }

    public long getTrapsReceived() {
        return this.trapsReceived;
    }
}

