/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import com.google.common.collect.ImmutableList;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.opennms.core.collections.RadixTree;
import org.opennms.core.collections.RadixTreeImpl;
import org.opennms.core.collections.RadixTreeNode;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.syslogd.GrokParserStageSequenceBuilder;
import org.opennms.netmgt.syslogd.ParserStage;
import org.opennms.netmgt.syslogd.ParserState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserStageSequenceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ParserStageSequenceBuilder.class);
    final List<ParserStage> m_stages = new ArrayList<ParserStage>();
    final Stack<Boolean> m_optional = new Stack();
    final Stack<Boolean> m_terminal = new Stack();

    public List<ParserStage> getStages() {
        return Collections.unmodifiableList(this.m_stages);
    }

    public ParserStageSequenceBuilder optional() {
        this.m_optional.push(true);
        return this;
    }

    public ParserStageSequenceBuilder terminal() {
        this.m_terminal.push(true);
        return this;
    }

    private boolean getOptional() {
        try {
            return this.m_optional.pop();
        }
        catch (EmptyStackException e) {
            return false;
        }
    }

    private boolean getTerminal() {
        try {
            return this.m_terminal.pop();
        }
        catch (EmptyStackException e) {
            return false;
        }
    }

    private void addStage(ParserStage stage) {
        stage.setOptional(this.getOptional());
        stage.setTerminal(this.getTerminal());
        this.m_stages.add(stage);
    }

    private static CharPredicate getHostMatcherForPattern(GrokParserStageSequenceBuilder.GrokPattern pattern) {
        ImmutableList hostNameCharacters = ImmutableList.of((Object)Character.valueOf('-'), (Object)Character.valueOf('.'), (Object)Character.valueOf('_'));
        CharPredicate hostNameMatcher = arg_0 -> ParserStageSequenceBuilder.lambda$getHostMatcherForPattern$0((List)hostNameCharacters, arg_0);
        CharPredicate ipV4AddressMatcher = c -> Character.isDigit(c) || c == '.';
        CharPredicate ipV6AddressMatcher = c -> Character.digit(c, 16) >= 0 || c == ':';
        CharPredicate ipV4OrV6AddressMatcher = ipV4AddressMatcher.or(ipV6AddressMatcher);
        CharPredicate hostnameOrIPMatcher = hostNameMatcher.or(ipV4OrV6AddressMatcher);
        switch (pattern) {
            case HOSTNAME: {
                return hostNameMatcher;
            }
            case HOSTNAMEORIP: {
                return hostnameOrIPMatcher;
            }
            case IPADDRESS: {
                return ipV4OrV6AddressMatcher;
            }
        }
        throw new IllegalArgumentException("Unsupported host pattern '" + (Object)((Object)pattern) + "'");
    }

    public ParserStageSequenceBuilder whitespace() {
        this.addStage(new MatchWhitespace());
        return this;
    }

    public ParserStageSequenceBuilder character(BiConsumer<ParserState, String> consumer) {
        this.addStage(new MatchAny(consumer, 1));
        return this;
    }

    public ParserStageSequenceBuilder character(char character) {
        this.addStage(new MatchChar(character));
        return this;
    }

    public ParserStageSequenceBuilder string(BiConsumer<ParserState, String> consumer) {
        this.addStage(new MatchAny(consumer, Integer.MAX_VALUE));
        return this;
    }

    public ParserStageSequenceBuilder integer(BiConsumer<ParserState, Integer> consumer) {
        this.addStage(new MatchInteger(consumer));
        return this;
    }

    public ParserStageSequenceBuilder hostMatcherForPattern(GrokParserStageSequenceBuilder.GrokPattern pattern, BiConsumer<ParserState, String> consumer) {
        this.addStage(new MatchOnly(consumer, Integer.MAX_VALUE, ParserStageSequenceBuilder.getHostMatcherForPattern(pattern)));
        return this;
    }

    public ParserStageSequenceBuilder monthString(BiConsumer<ParserState, Integer> consumer) {
        this.addStage(new MatchMonth(consumer));
        return this;
    }

    public ParserStageSequenceBuilder hostUntilForPattern(GrokParserStageSequenceBuilder.GrokPattern pattern, String ends, BiConsumer<ParserState, String> consumer) {
        this.addStage(new MatchOnlyStringUntil(consumer, ends, ParserStageSequenceBuilder.getHostMatcherForPattern(pattern)));
        return this;
    }

    public ParserStageSequenceBuilder stringUntil(String ends, BiConsumer<ParserState, String> consumer) {
        this.addStage(new MatchStringUntil(consumer, ends));
        return this;
    }

    public ParserStageSequenceBuilder stringUntilWhitespace(BiConsumer<ParserState, String> consumer) {
        this.addStage(new MatchStringUntil(consumer, "\\s"));
        return this;
    }

    public ParserStageSequenceBuilder stringUntilNonWhitespace(BiConsumer<ParserState, String> consumer) {
        this.addStage(new MatchUntilNot<String>(consumer, new char[]{' ', '\t'}));
        return this;
    }

    public ParserStageSequenceBuilder stringUntilChar(char end, BiConsumer<ParserState, String> consumer) {
        this.addStage(new MatchStringUntil(consumer, end));
        return this;
    }

    public ParserStageSequenceBuilder intUntilWhitespace(BiConsumer<ParserState, Integer> consumer) {
        this.addStage(new MatchIntegerUntil(consumer, "\\s"));
        return this;
    }

    public ParserStageSequenceBuilder stringBetweenDelimiters(char start, char end, BiConsumer<ParserState, String> consumer) {
        this.addStage(new MatchChar(start));
        this.addStage(new MatchStringUntil(consumer, end));
        this.addStage(new MatchChar(end));
        return this;
    }

    public ParserStageSequenceBuilder intBetweenDelimiters(char start, char end, BiConsumer<ParserState, Integer> consumer) {
        this.addStage(new MatchChar(start));
        this.addStage(new MatchIntegerUntil(consumer, end));
        this.addStage(new MatchChar(end));
        return this;
    }

    private static /* synthetic */ boolean lambda$getHostMatcherForPattern$0(List hostNameCharacters, char c) {
        return Character.isDigit(c) || Character.isLetter(c) || hostNameCharacters.contains(Character.valueOf(c));
    }

    static class MatchInteger
    extends AbstractParserStage<Integer> {
        MatchInteger(BiConsumer<ParserState, Integer> consumer) {
            super(consumer);
        }

        @Override
        public ParserStage.AcceptResult acceptChar(ParserStageState state, char c) {
            if (c >= '0' && c <= '9') {
                MatchInteger.accumulate(state, c);
                return ParserStage.AcceptResult.CONTINUE;
            }
            if (MatchInteger.getAccumulatedSize(state) > 0) {
                return ParserStage.AcceptResult.COMPLETE_WITHOUT_CONSUMING;
            }
            return ParserStage.AcceptResult.CANCEL;
        }

        @Override
        public Integer getValue(ParserStageState state) {
            return MatchInteger.trimAndConvert(MatchInteger.getAccumulatedValue(state));
        }

        public static int trimAndConvert(String value) {
            boolean trimmed = false;
            while (value.startsWith("0")) {
                value = value.substring(1);
                trimmed = true;
            }
            if ("".equals(value)) {
                return trimmed ? Integer.valueOf(0) : null;
            }
            return StringUtils.parseDecimalInt((String)value, (boolean)false);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchInteger)) {
                return false;
            }
            MatchInteger other = (MatchInteger)o;
            return Objects.equals(this.m_resultConsumer, other.m_resultConsumer);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
        }
    }

    static class MatchIntegerUntil
    extends MatchUntil<Integer> {
        public MatchIntegerUntil(BiConsumer<ParserState, Integer> consumer, char end) {
            super(consumer, end);
        }

        public MatchIntegerUntil(BiConsumer<ParserState, Integer> consumer, String ends) {
            super(consumer, ends);
        }

        @Override
        public Integer getValue(ParserStageState state) {
            String value = MatchIntegerUntil.getAccumulatedValue(state);
            boolean trimmed = false;
            while (value.startsWith("0")) {
                value = value.substring(1);
                trimmed = true;
            }
            if ("".equals(value)) {
                return trimmed ? Integer.valueOf(0) : null;
            }
            return StringUtils.parseDecimalInt((String)value, (boolean)false);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchIntegerUntil)) {
                return false;
            }
            return super.equals(o);
        }
    }

    static class MatchOnlyStringUntil
    extends MatchOnlyUntil<String> {
        public MatchOnlyStringUntil(BiConsumer<ParserState, String> consumer, String ends, CharPredicate charMatcher) {
            super(consumer, ends, charMatcher);
        }

        @Override
        public String getValue(ParserStageState state) {
            return MatchOnlyStringUntil.getAccumulatedValue(state);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchOnlyStringUntil)) {
                return false;
            }
            return super.equals(o);
        }
    }

    static class MatchStringUntil
    extends MatchUntil<String> {
        public MatchStringUntil(BiConsumer<ParserState, String> consumer, char end) {
            super(consumer, end);
        }

        public MatchStringUntil(BiConsumer<ParserState, String> consumer, String ends) {
            super(consumer, ends);
        }

        @Override
        public String getValue(ParserStageState state) {
            return MatchStringUntil.getAccumulatedValue(state);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchStringUntil)) {
                return false;
            }
            return super.equals(o);
        }
    }

    static abstract class MatchOnlyUntil<R>
    extends MatchUntil<R> {
        private final CharPredicate m_charMatcher;

        MatchOnlyUntil(BiConsumer<ParserState, R> consumer, String end, CharPredicate charMatcher) {
            super(consumer, end);
            this.m_charMatcher = charMatcher;
        }

        @Override
        public ParserStage.AcceptResult acceptChar(ParserStageState state, char c) {
            for (char end : this.getEnd()) {
                if (end != c && this.m_charMatcher.test(c)) continue;
                return ParserStage.AcceptResult.COMPLETE_WITHOUT_CONSUMING;
            }
            if (this.isEndOnWhitespace() && (c == ' ' || c == '\t')) {
                return ParserStage.AcceptResult.COMPLETE_WITHOUT_CONSUMING;
            }
            MatchOnlyUntil.accumulate(state, c);
            return ParserStage.AcceptResult.CONTINUE;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchOnlyUntil)) {
                return false;
            }
            MatchOnlyUntil other = (MatchOnlyUntil)o;
            return Arrays.equals(this.getEnd(), other.getEnd()) && Objects.equals(this.isEndOnWhitespace(), other.isEndOnWhitespace() && Objects.equals(this.m_resultConsumer, other.m_resultConsumer));
        }
    }

    static abstract class MatchUntil<R>
    extends AbstractParserStage<R> {
        public static final String WHITESPACE = "\\s";
        private final char[] m_end;
        private boolean m_endOnwhitespace = false;

        MatchUntil(BiConsumer<ParserState, R> consumer, char end) {
            super(consumer);
            this.m_end = new char[]{end};
        }

        public char[] getEnd() {
            return this.m_end;
        }

        public boolean isEndOnWhitespace() {
            return this.m_endOnwhitespace;
        }

        MatchUntil(BiConsumer<ParserState, R> consumer, String end) {
            super(consumer);
            this.m_endOnwhitespace = end.contains(WHITESPACE);
            end = end.replaceAll("\\\\s", "");
            this.m_end = end.toCharArray();
        }

        @Override
        public ParserStage.AcceptResult acceptChar(ParserStageState state, char c) {
            for (char end : this.m_end) {
                if (end != c) continue;
                return ParserStage.AcceptResult.COMPLETE_WITHOUT_CONSUMING;
            }
            if (this.m_endOnwhitespace && (c == ' ' || c == '\t')) {
                return ParserStage.AcceptResult.COMPLETE_WITHOUT_CONSUMING;
            }
            MatchUntil.accumulate(state, c);
            return ParserStage.AcceptResult.CONTINUE;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("ends", this.m_end).append("endOnWhitespace", this.m_endOnwhitespace).toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchUntil)) {
                return false;
            }
            MatchUntil other = (MatchUntil)o;
            return Arrays.equals(this.m_end, other.getEnd()) && Objects.equals(this.m_endOnwhitespace, other.isEndOnWhitespace() && Objects.equals(this.m_resultConsumer, other.m_resultConsumer));
        }
    }

    static class MatchUntilNot<R>
    extends AbstractParserStage<R> {
        private final char[] m_accepted;

        public MatchUntilNot(BiConsumer<ParserState, R> resultConsumer, char[] acceptedChars) {
            super(resultConsumer);
            this.m_accepted = acceptedChars;
        }

        @Override
        public ParserStage.AcceptResult acceptChar(ParserStageState state, char c) {
            for (char acceptable : this.m_accepted) {
                if (c != acceptable) continue;
                MatchUntilNot.accumulate(state, c);
                return ParserStage.AcceptResult.CONTINUE;
            }
            return ParserStage.AcceptResult.COMPLETE_WITHOUT_CONSUMING;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchUntilNot that = (MatchUntilNot)o;
            return this.m_accepted == that.m_accepted;
        }

        public String toString() {
            return "MatchUntilNot{m_accepted=" + this.m_accepted + "} " + super.toString();
        }
    }

    static class MatchOnly
    extends MatchAny {
        private final CharPredicate m_charMatcher;

        public MatchOnly(BiConsumer<ParserState, String> consumer, int length, CharPredicate charMatcher) {
            super(consumer, length);
            this.m_charMatcher = charMatcher;
        }

        @Override
        public ParserStage.AcceptResult acceptChar(ParserStageState state, char c) {
            if (MatchOnly.getAccumulatedSize(state) >= this.getLength()) {
                return ParserStage.AcceptResult.COMPLETE_AFTER_CONSUMING;
            }
            if (this.m_charMatcher.test(c)) {
                MatchOnly.accumulate(state, c);
                return ParserStage.AcceptResult.CONTINUE;
            }
            if (MatchOnly.getAccumulatedSize(state) > 0) {
                return ParserStage.AcceptResult.COMPLETE_WITHOUT_CONSUMING;
            }
            return ParserStage.AcceptResult.CANCEL;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchOnly)) {
                return false;
            }
            MatchOnly other = (MatchOnly)o;
            return Objects.equals(this.getLength(), other.getLength()) && Objects.equals(this.m_resultConsumer, other.m_resultConsumer);
        }
    }

    static class MatchAny
    extends AbstractParserStage<String> {
        private final int m_length;

        public MatchAny() {
            this(null, 1);
        }

        public MatchAny(BiConsumer<ParserState, String> consumer) {
            this(consumer, 1);
        }

        public MatchAny(int length) {
            this(null, length);
        }

        public MatchAny(BiConsumer<ParserState, String> consumer, int length) {
            super(consumer);
            this.m_length = length;
        }

        public int getLength() {
            return this.m_length;
        }

        @Override
        public ParserStage.AcceptResult acceptChar(ParserStageState state, char c) {
            MatchAny.accumulate(state, c);
            if (MatchAny.getAccumulatedSize(state) >= this.m_length) {
                return ParserStage.AcceptResult.COMPLETE_AFTER_CONSUMING;
            }
            return ParserStage.AcceptResult.CONTINUE;
        }

        @Override
        public String getValue(ParserStageState state) {
            return MatchAny.getAccumulatedValue(state);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("length", this.m_length).toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchAny)) {
                return false;
            }
            MatchAny other = (MatchAny)o;
            return Objects.equals(this.m_length, other.getLength()) && Objects.equals(this.m_resultConsumer, other.m_resultConsumer);
        }
    }

    static class MatchMonth
    extends AbstractParserStage<Integer> {
        private static final RadixTree<CharacterWithValue> MONTH_STRINGS = new RadixTreeImpl();

        public MatchMonth(BiConsumer<ParserState, Integer> consumer) {
            super(consumer);
        }

        @Override
        public ParserStage.AcceptResult acceptChar(ParserStageState state, char c) {
            if (state.currentNode == null) {
                state.currentNode = MONTH_STRINGS;
            }
            for (RadixTreeNode child : state.currentNode.getChildren()) {
                if (((CharacterWithValue)child.getContent()).getCharacter() != c) continue;
                state.currentNode = child;
                if (child.getChildren().isEmpty()) {
                    return ParserStage.AcceptResult.COMPLETE_AFTER_CONSUMING;
                }
                return ParserStage.AcceptResult.CONTINUE;
            }
            return ParserStage.AcceptResult.CANCEL;
        }

        @Override
        public Integer getValue(ParserStageState state) {
            return ((CharacterWithValue)state.currentNode.getContent()).getValue();
        }

        @Override
        public void reset(ParserStageState state) {
            super.reset(state);
            state.currentNode = null;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchMonth)) {
                return false;
            }
            MatchMonth other = (MatchMonth)o;
            return Objects.equals(this.m_resultConsumer, other.m_resultConsumer);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
        }

        static {
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Jan", 1));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("jan", 1));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Feb", 2));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("feb", 2));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Mar", 3));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("mar", 3));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Apr", 4));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("apr", 4));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("May", 5));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("may", 5));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Jun", 6));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("jun", 6));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Jul", 7));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("jul", 7));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Aug", 8));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("aug", 8));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Sep", 9));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("sep", 9));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Oct", 10));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("oct", 10));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Nov", 11));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("nov", 11));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("Dec", 12));
            MONTH_STRINGS.addChildren((Object[])CharacterWithValue.toArray("dec", 12));
        }
    }

    private static class CharacterWithValue {
        private final char character;
        private final int value;

        public static CharacterWithValue[] toArray(String string, Integer value) {
            return string.chars().mapToObj(c -> new CharacterWithValue(Character.valueOf((char)c), value)).collect(Collectors.toList()).toArray(new CharacterWithValue[0]);
        }

        private CharacterWithValue(Character character, Integer value) {
            this.character = character.charValue();
            this.value = value;
        }

        public char getCharacter() {
            return this.character;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof CharacterWithValue)) {
                return false;
            }
            CharacterWithValue other = (CharacterWithValue)o;
            return Objects.equals(Character.valueOf(this.character), Character.valueOf(other.getCharacter()));
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("character", this.character).append("value", this.value).toString();
        }
    }

    static class MatchChar
    extends AbstractParserStage<Void> {
        private final char m_char;

        MatchChar(char c) {
            this.m_char = c;
        }

        public char getChar() {
            return this.m_char;
        }

        @Override
        public ParserStage.AcceptResult acceptChar(ParserStageState state, char c) {
            if (c == this.m_char) {
                return ParserStage.AcceptResult.COMPLETE_AFTER_CONSUMING;
            }
            return ParserStage.AcceptResult.CANCEL;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchChar)) {
                return false;
            }
            MatchChar other = (MatchChar)o;
            return Objects.equals(Character.valueOf(this.m_char), Character.valueOf(other.getChar())) && Objects.equals(this.m_resultConsumer, other.m_resultConsumer);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("char", this.m_char).toString();
        }
    }

    static class MatchWhitespace
    extends AbstractParserStage<Void> {
        MatchWhitespace() {
        }

        @Override
        public ParserStage.AcceptResult acceptChar(ParserStageState state, char c) {
            if (c == ' ' || c == '\t') {
                return ParserStage.AcceptResult.CONTINUE;
            }
            return ParserStage.AcceptResult.COMPLETE_WITHOUT_CONSUMING;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchWhitespace)) {
                return false;
            }
            MatchWhitespace other = (MatchWhitespace)o;
            return Objects.equals(this.m_resultConsumer, other.m_resultConsumer);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
        }
    }

    private static abstract class AbstractParserStage<R>
    implements ParserStage {
        private boolean m_optional = false;
        private boolean m_terminal = false;
        protected final BiConsumer<ParserState, R> m_resultConsumer;

        protected AbstractParserStage() {
            this(null);
        }

        protected AbstractParserStage(BiConsumer<ParserState, R> resultConsumer) {
            this.m_resultConsumer = resultConsumer;
        }

        @Override
        public void setOptional(boolean optional) {
            this.m_optional = optional;
        }

        @Override
        public void setTerminal(boolean terminal) {
            this.m_terminal = terminal;
        }

        public abstract ParserStage.AcceptResult acceptChar(ParserStageState var1, char var2);

        @Override
        public final ParserState apply(ParserState incomingState) {
            if (incomingState == null) {
                return null;
            }
            LOG.trace("Starting stage: " + this);
            ParserState state = incomingState.clone();
            ParserStageState stageState = new ParserStageState(state.getBuffer());
            block12: while (true) {
                char c;
                stageState.buffer.mark();
                try {
                    c = (char)stageState.buffer.get();
                }
                catch (BufferUnderflowException e) {
                    if (this.m_terminal) {
                        if (this.m_resultConsumer != null) {
                            this.m_resultConsumer.accept(state, this.getValue(stageState));
                        }
                        LOG.trace("End of buffer with terminal match");
                        return new ParserState(stageState.buffer, state.message);
                    }
                    if (this.m_optional) {
                        LOG.trace("End of buffer with optional match");
                        return new ParserState(stageState.buffer, state.message);
                    }
                    LOG.trace("Parse failed due to buffer underflow: " + this);
                    return null;
                }
                switch (this.acceptChar(stageState, c)) {
                    case CONTINUE: {
                        continue block12;
                    }
                    case COMPLETE_AFTER_CONSUMING: {
                        if (this.m_resultConsumer != null) {
                            try {
                                this.m_resultConsumer.accept(state, this.getValue(stageState));
                            }
                            catch (Exception e) {
                                LOG.trace("Parse failed on result consumer: {}", (Object)stageState, (Object)e);
                                return null;
                            }
                        }
                        return new ParserState(stageState.buffer, state.message);
                    }
                    case COMPLETE_WITHOUT_CONSUMING: {
                        if (this.m_resultConsumer != null) {
                            try {
                                this.m_resultConsumer.accept(state, this.getValue(stageState));
                            }
                            catch (Exception e) {
                                LOG.trace("Parse failed on result consumer: {}", (Object)stageState, (Object)e);
                                return null;
                            }
                        }
                        this.reset(stageState);
                        stageState.buffer.reset();
                        return new ParserState(stageState.buffer, state.message);
                    }
                    case CANCEL: {
                        if (this.m_optional) {
                            stageState.buffer.reset();
                            this.reset(stageState);
                            return new ParserState(stageState.buffer, state.message);
                        }
                        LOG.trace("Parse failed: {}", (Object)this);
                        return null;
                    }
                }
            }
        }

        public void reset(ParserStageState state) {
        }

        protected static void accumulate(ParserStageState state, char c) {
            state.accumulate(c);
        }

        protected static int getAccumulatedSize(ParserStageState state) {
            return state.getAccumulatedSize();
        }

        protected static String getAccumulatedValue(ParserStageState state) {
            StringBuilder accumulatedValue = state.accumulatedValue;
            if (accumulatedValue == null) {
                return null;
            }
            return accumulatedValue.toString();
        }

        protected R getValue(ParserStageState state) {
            return null;
        }
    }

    private static class ParserStageState {
        public final ByteBuffer buffer;
        private StringBuilder accumulatedValue = null;
        private AtomicInteger accumulatedSize = null;
        public RadixTreeNode<CharacterWithValue> currentNode = null;

        public ParserStageState(ByteBuffer input) {
            this.buffer = input;
        }

        public void accumulate(char c) {
            this.accessAccumulatedValue().append(c);
            this.accessAccumulatedSize().incrementAndGet();
        }

        public int getAccumulatedSize() {
            return this.accessAccumulatedSize().get();
        }

        private final StringBuilder accessAccumulatedValue() {
            if (this.accumulatedValue == null) {
                this.accumulatedValue = new StringBuilder();
            }
            return this.accumulatedValue;
        }

        private final AtomicInteger accessAccumulatedSize() {
            if (this.accumulatedSize == null) {
                this.accumulatedSize = new AtomicInteger();
            }
            return this.accumulatedSize;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("accumulatedValue", (Object)(this.accumulatedValue == null ? "null" : this.accumulatedValue.toString())).append("accumulatedSize", this.accumulatedSize == null ? 0 : this.accumulatedSize.get()).toString();
        }
    }

    @FunctionalInterface
    private static interface CharPredicate {
        public boolean test(char var1);

        default public CharPredicate negate() {
            return c -> !this.test(c);
        }

        default public CharPredicate and(CharPredicate other) {
            Objects.requireNonNull(other);
            return c -> this.test(c) && other.test(c);
        }

        default public CharPredicate or(CharPredicate other) {
            Objects.requireNonNull(other);
            return c -> this.test(c) || other.test(c);
        }
    }
}

