/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.List;
import java.util.concurrent.Callable;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyslogProcessor
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogProcessor.class);
    private final boolean m_NewSuspectOnMessage;
    private final String m_localAddr;
    private final Event m_event;

    public SyslogProcessor(Event event, boolean newSuspectOnMessage) {
        this.m_event = event;
        this.m_NewSuspectOnMessage = newSuspectOnMessage;
        this.m_localAddr = InetAddressUtils.getLocalHostName();
    }

    public Event getEvent() {
        return this.m_event;
    }

    @Override
    public Void call() {
        try {
            if (LOG.isTraceEnabled()) {
                List parms;
                LOG.trace("Processing a syslog to event dispatch", (Object)this.m_event.toString());
                String uuid = this.m_event.getUuid();
                LOG.trace("Event {");
                LOG.trace("  uuid  = {}", (Object)(uuid != null && uuid.length() > 0 ? uuid : "<not-set>"));
                LOG.trace("  uei   = {}", (Object)this.m_event.getUei());
                LOG.trace("  src   = {}", (Object)this.m_event.getSource());
                LOG.trace("  iface = {}", (Object)this.m_event.getInterface());
                LOG.trace("  time  = {}", (Object)this.m_event.getTime());
                LOG.trace("  Msg   = {}", (Object)this.m_event.getLogmsg().getContent());
                LOG.trace("  Dst   = {}", (Object)this.m_event.getLogmsg().getDest());
                List list = parms = this.m_event.getParmCollection() == null ? null : this.m_event.getParmCollection();
                if (parms != null) {
                    LOG.trace("  parms {");
                    for (Parm parm : parms) {
                        if (parm.getParmName() == null || parm.getValue().getContent() == null) continue;
                        LOG.trace("    ({}, {})", (Object)parm.getParmName().trim(), (Object)parm.getValue().getContent().trim());
                    }
                    LOG.trace("  }");
                }
                LOG.trace("}");
            }
            EventIpcManagerFactory.getIpcManager().sendNow(this.m_event);
            if (this.m_NewSuspectOnMessage && !this.m_event.hasNodeid()) {
                LOG.trace("Syslogd: Found a new suspect {}", (Object)this.m_event.getInterface());
                SyslogProcessor.sendNewSuspectEvent(this.m_localAddr, this.m_event.getInterface());
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected error processing SyslogMessage - Could not send", t);
        }
        return null;
    }

    private static void sendNewSuspectEvent(String localAddr, String trapInterface) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "syslogd");
        bldr.setInterface(InetAddressUtils.addr((String)trapInterface));
        bldr.setHost(localAddr);
        EventIpcManagerFactory.getIpcManager().sendNow(bldr.getEvent());
    }
}

