/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.listener;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlEventProcessor
extends ChannelInboundHandlerAdapter {
    private static final Comparator<Event> EVENT_COMPARATOR = (e1, e2) -> {
        boolean e2t;
        boolean e1t = e1.getTime() != null;
        boolean bl = e2t = e2.getTime() != null;
        if (e1t && !e2t) {
            return 1;
        }
        if (!e1t && e2t) {
            return -1;
        }
        if (!e1t && !e2t) {
            return 0;
        }
        Date de1 = e1.getTime();
        Date de2 = e2.getTime();
        if (de1 != null && de2 != null) {
            return (int)(de1.getTime() - de2.getTime());
        }
        if (de1 == null && de2 != null) {
            return -1;
        }
        if (de1 != null && de2 == null) {
            return 1;
        }
        return 0;
    };
    private static final Logger LOG = LoggerFactory.getLogger(XmlEventProcessor.class);
    private final EventForwarder eventForwarder;

    public XmlEventProcessor(EventForwarder eventForwarder) {
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (!(msg instanceof ByteBuf)) {
                LOG.warn("Expected message to be of type {} but received {}. Ignoring message.", ByteBuf.class, msg == null ? null : msg.getClass());
                return;
            }
            ByteBuf buffer = (ByteBuf)msg;
            Log eventLog = XmlEventProcessor.getEventLog(buffer);
            if (eventLog.getEvents() != null && eventLog.getEvents().getEvent() != null && eventLog.getEvents().getEvent().length != 0) {
                Optional<String> receipt = this.process(eventLog);
                if (receipt.isPresent()) {
                    ctx.write((Object)receipt.get());
                    LOG.debug("Sent Event Receipt: {}", (Object)receipt.get());
                }
            } else {
                LOG.debug("The agent sent an empty event stream.");
            }
        }
        finally {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("An error occurred while processing the event: {}", (Object)cause.getMessage(), (Object)cause);
    }

    private Optional<String> process(Log eventLog) {
        Event[] events = eventLog.getEvents().getEvent();
        Arrays.sort(events, EVENT_COMPARATOR);
        ArrayList<Event> okEvents = new ArrayList<Event>(events.length);
        for (Event event : events) {
            try {
                LOG.debug("handling event: {}", (Object)event);
                this.eventForwarder.sendNow(event);
                if (okEvents.contains(event)) continue;
                okEvents.add(event);
            }
            catch (Throwable t) {
                LOG.warn("An exception occured while processing an event.", t);
            }
        }
        boolean hasReceipt = false;
        EventReceipt receipt = new EventReceipt();
        for (Event event : okEvents) {
            if (event.getUuid() == null) continue;
            receipt.addUuid(event.getUuid());
            hasReceipt = true;
        }
        if (hasReceipt) {
            StringWriter writer = new StringWriter();
            JaxbUtils.marshal((Object)receipt, (Writer)writer);
            writer.flush();
            return Optional.of(writer.toString());
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Log getEventLog(ByteBuf buf) throws IOException {
        String xml = buf.toString(CharsetUtil.UTF_8);
        try (ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes());){
            Log eventLog = (Log)JaxbUtils.unmarshal(Log.class, (InputStream)input);
            LOG.debug("Event record converted");
            Log log = eventLog;
            return log;
        }
        catch (Throwable e) {
            LOG.error("Could not unmarshal the XML record", e);
            throw e;
        }
    }
}

