/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.ExpandableParameterResolverRegistry;
import org.opennms.netmgt.eventd.processor.expandable.EventTemplate;
import org.opennms.netmgt.eventd.processor.expandable.ExpandableParameterResolver;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionOperations;

public abstract class AbstractEventUtil
implements EventUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventUtil.class);
    protected static final String TAG_EVENT_DB_ID = "eventid";
    protected static final String TAG_UEI = "uei";
    protected static final String TAG_SOURCE = "source";
    protected static final String TAG_DESCR = "descr";
    protected static final String TAG_LOGMSG = "logmsg";
    protected static final String TAG_TIME = "time";
    protected static final String TAG_SHORT_TIME = "shorttime";
    protected static final String TAG_DPNAME = "dpname";
    protected static final String TAG_NODEID = "nodeid";
    protected static final String TAG_NODELABEL = "nodelabel";
    protected static final String TAG_NODELOCATION = "nodelocation";
    protected static final String TAG_HOST = "host";
    protected static final String TAG_INTERFACE = "interface";
    protected static final String TAG_FOREIGNSOURCE = "foreignsource";
    protected static final String TAG_FOREIGNID = "foreignid";
    protected static final String TAG_IFINDEX = "ifindex";
    protected static final String TAG_INTERFACE_RESOLVE = "interfaceresolve";
    protected static final String TAG_IFALIAS = "ifalias";
    protected static final String TAG_SNMP_ID = "id";
    protected static final String TAG_SNMP = "snmp";
    protected static final String TAG_SNMP_IDTEXT = "idtext";
    protected static final String TAG_SNMP_VERSION = "version";
    protected static final String TAG_SNMP_SPECIFIC = "specific";
    protected static final String TAG_SNMP_GENERIC = "generic";
    protected static final String TAG_SNMP_COMMUNITY = "community";
    protected static final String TAG_SNMPHOST = "snmphost";
    protected static final String TAG_SERVICE = "service";
    protected static final String TAG_SEVERITY = "severity";
    protected static final String TAG_OPERINSTR = "operinstruct";
    protected static final String TAG_MOUSEOVERTEXT = "mouseovertext";
    protected static final String TAG_TTICKET_ID = "tticketid";
    protected static final String ASSET_BEGIN = "asset[";
    protected static final String ASSET_END_SUFFIX = "]";
    protected static final String PARMS_NAMES = "parm[names-all]";
    protected static final String PARMS_VALUES = "parm[values-all]";
    protected static final String PARMS_ALL = "parm[all]";
    protected static final String PARM_BEGIN = "parm[";
    protected static final Pattern PARM_REGEX = Pattern.compile("^parm\\[(.*)\\]$");
    protected static final int PARM_BEGIN_LENGTH = 5;
    protected static final String NUM_PARMS_STR = "parm[##]";
    protected static final String PARM_NUM_PREFIX = "parm[#";
    protected static final int PARM_NUM_PREFIX_LENGTH = 6;
    protected static final String PARM_NAME_NUMBERED_PREFIX = "parm[name-#";
    protected static final int PARM_NAME_NUMBERED_PREFIX_LENGTH = 11;
    protected static final String PARM_END_SUFFIX = "]";
    protected static final char NAME_VAL_DELIM = '=';
    protected static final char SPACE_DELIM = ' ';
    protected static final char ATTRIB_DELIM = ',';
    protected static final String TAG_PERCENT_SIGN = "pctsign";
    protected static final String HARDWARE_BEGIN = "hardware[";
    protected static final String HARDWARE_END_SUFFIX = "]";
    private static EventUtil m_instance = null;
    @Autowired
    private TransactionOperations transactionOperations;
    private final LoadingCache<String, EventTemplate> eventTemplateCache;
    private final ExpandableParameterResolverRegistry resolverRegistry = new ExpandableParameterResolverRegistry();

    public static synchronized EventUtil getInstance() {
        if (m_instance == null) {
            return (EventUtil)BeanUtils.getBean((String)"eventDaemonContext", (String)"eventUtil", EventUtil.class);
        }
        return m_instance;
    }

    public static void setInstance(EventUtil instance) {
        m_instance = instance;
    }

    public static String escape(String inStr, char delimchar) {
        char delim = delimchar;
        String delimEscStr = "%" + String.valueOf((int)delim);
        StringBuilder outBuffer = new StringBuilder(inStr);
        int index = 0;
        int delimIndex = inStr.indexOf(delimchar, index);
        while (delimIndex != -1) {
            outBuffer.deleteCharAt(delimIndex);
            outBuffer.insert(delimIndex, delimEscStr);
            index = delimIndex + delimEscStr.length() + 1;
            delimIndex = outBuffer.toString().indexOf(delimchar, index);
        }
        return outBuffer.toString();
    }

    public AbstractEventUtil() {
        this(null);
    }

    public AbstractEventUtil(MetricRegistry registry) {
        final long maximumCacheSize = Long.parseLong(System.getProperty("org.opennms.eventd.eventTemplateCacheSize", "1000"));
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(maximumCacheSize);
        if (registry != null) {
            cacheBuilder.recordStats();
        }
        this.eventTemplateCache = cacheBuilder.build((CacheLoader)new CacheLoader<String, EventTemplate>(){

            public EventTemplate load(String key) throws Exception {
                return new EventTemplate(key, AbstractEventUtil.this);
            }
        });
        if (registry != null) {
            registry.register(MetricRegistry.name((String)"eventutil.cache.capacity", (String[])new String[0]), (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return maximumCacheSize;
                }
            });
            registry.register(MetricRegistry.name((String)"eventutil.cache.size", (String[])new String[0]), (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return AbstractEventUtil.this.eventTemplateCache.size();
                }
            });
            registry.register(MetricRegistry.name((String)"eventutil.cache.evictioncount", (String[])new String[0]), (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return AbstractEventUtil.this.eventTemplateCache.stats().evictionCount();
                }
            });
            registry.register(MetricRegistry.name((String)"eventutil.cache.avgloadpenalty", (String[])new String[0]), (Metric)new Gauge<Double>(){

                public Double getValue() {
                    return AbstractEventUtil.this.eventTemplateCache.stats().averageLoadPenalty();
                }
            });
        }
    }

    protected static String getAllParmValues(Event event) {
        String retParmVal = null;
        if (event.getParmCollection().size() < 1) {
            retParmVal = null;
        } else {
            StringBuilder ret = new StringBuilder();
            for (Parm evParm : event.getParmCollection()) {
                String parmValueStr;
                Value parmValue = evParm.getValue();
                if (parmValue == null || (parmValueStr = EventConstants.getValueAsString((Value)parmValue)) == null) continue;
                if (ret.length() == 0) {
                    ret.append(parmValueStr);
                    continue;
                }
                ret.append(' ' + parmValueStr);
            }
            retParmVal = ret.toString();
        }
        return retParmVal;
    }

    protected static String getAllParmNames(Event event) {
        if (event.getParmCollection().size() <= 0) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (Parm evParm : event.getParmCollection()) {
            String parmName = evParm.getParmName();
            if (parmName == null) continue;
            if (ret.length() == 0) {
                ret.append(parmName.trim());
                continue;
            }
            ret.append(' ' + parmName.trim());
        }
        return ret.toString();
    }

    protected static String getAllParamValues(Event event) {
        if (event.getParmCollection().size() < 1) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (Parm evParm : event.getParmCollection()) {
            Value parmValue;
            String parmName = evParm.getParmName();
            if (parmName == null || (parmValue = evParm.getValue()) == null) continue;
            String parmValueStr = EventConstants.getValueAsString((Value)parmValue);
            if (ret.length() != 0) {
                ret.append(' ');
            }
            ret.append(parmName.trim()).append('=').append("\"").append(parmValueStr).append("\"");
        }
        return ret.toString().intern();
    }

    protected static String getNumParmName(String parm, Event event) {
        String retParmVal = null;
        List parms = event.getParmCollection();
        int end = parm.lastIndexOf("]");
        if (end != -1 && parms != null && parms.size() > 0) {
            String parmSpec = parm.substring(11, end);
            String eparmnum = null;
            String eparmsep = null;
            String eparmoffset = null;
            String eparmrangesep = null;
            String eparmrangelen = null;
            if (parmSpec.matches("^\\d+$")) {
                eparmnum = parmSpec;
            } else {
                Matcher m = Pattern.compile("^(\\d+)([^0-9+-]+)([+-]?\\d+)((:)([+-]?\\d+)?)?$").matcher(parmSpec);
                if (m.matches()) {
                    eparmnum = m.group(1);
                    eparmsep = m.group(2);
                    eparmoffset = m.group(3);
                    eparmrangesep = m.group(5);
                    eparmrangelen = m.group(6);
                }
            }
            int parmNum = -1;
            try {
                parmNum = Integer.parseInt(eparmnum);
            }
            catch (NumberFormatException nfe) {
                parmNum = -1;
                retParmVal = null;
            }
            if (parmNum > 0 && parmNum <= parms.size()) {
                Parm evParm = (Parm)parms.get(parmNum - 1);
                String eparmname = evParm.getParmName();
                if (eparmsep != null && eparmoffset != null) {
                    int parmOffset = Integer.parseInt(eparmoffset);
                    boolean doRange = ":".equals(eparmrangesep);
                    int parmRangeLen = eparmrangelen == null ? 0 : Integer.parseInt(eparmrangelen);
                    retParmVal = AbstractEventUtil.splitAndExtract(eparmname, eparmsep, parmOffset, doRange, parmRangeLen);
                } else {
                    retParmVal = eparmname;
                }
            } else {
                retParmVal = null;
            }
        }
        return retParmVal;
    }

    public static String splitAndExtract(String src, String sep, int offset, boolean doRange, int rangeLen) {
        String sepLiteral = Pattern.quote(sep);
        if (src.startsWith(sep)) {
            src = src.replaceFirst(sepLiteral, "");
        }
        String[] components = src.split(sepLiteral);
        if (Math.abs(offset) > components.length || offset == 0) {
            return null;
        }
        int startIndex = offset < 0 ? components.length + offset : offset - 1;
        int endIndex = startIndex;
        if (!doRange) {
            return components[startIndex];
        }
        endIndex = rangeLen == 0 ? components.length - 1 : (rangeLen < 0 ? startIndex + 1 + rangeLen : startIndex - 1 + rangeLen);
        StringBuilder retVal = new StringBuilder();
        for (int i = startIndex; i <= endIndex; ++i) {
            retVal.append(components[i]);
            if (i >= endIndex) continue;
            retVal.append(sep);
        }
        return retVal.toString();
    }

    protected static String getNumParmValue(String parm, Event event) {
        String retParmVal = null;
        List parms = event.getParmCollection();
        int end = parm.lastIndexOf("]");
        if (end != -1 && parms != null && parms.size() > 0) {
            String eparmname = parm.substring(6, end);
            int parmNum = -1;
            try {
                parmNum = Integer.parseInt(eparmname);
            }
            catch (NumberFormatException nfe) {
                parmNum = -1;
                retParmVal = null;
            }
            if (parmNum > 0 && parmNum <= parms.size()) {
                Parm evParm = (Parm)parms.get(parmNum - 1);
                Value eparmval = evParm.getValue();
                if (eparmval != null) {
                    retParmVal = EventConstants.getValueAsString((Value)eparmval);
                }
            } else {
                retParmVal = null;
            }
        }
        return retParmVal;
    }

    @Override
    public String getNamedParmValue(String parm, Event event) {
        Value eparmval;
        Matcher matcher = PARM_REGEX.matcher(parm);
        if (!matcher.matches()) {
            return null;
        }
        String eparmname = matcher.group(1);
        Parm evParm = event.getParmTrim(eparmname);
        if (evParm != null && (eparmval = evParm.getValue()) != null) {
            return EventConstants.getValueAsString((Value)eparmval);
        }
        return null;
    }

    @Override
    public void expandMapValues(Map<String, String> map, Event event) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String expandedValue;
            String key = entry.getKey();
            String mapValue = entry.getValue();
            if (mapValue == null || (expandedValue = this.expandParms(map.get(key), event)) == null) continue;
            map.put(key, expandedValue);
        }
    }

    @Override
    public String expandParms(String inp, Event event) {
        return this.expandParms(inp, event, null);
    }

    @Override
    public String expandParms(String input, Event event, Map<String, Map<String, String>> decode) {
        if (input == null) {
            return null;
        }
        try {
            EventTemplate eventTemplate = (EventTemplate)this.eventTemplateCache.get((Object)input);
            Supplier<String> expander = () -> eventTemplate.expand(event, decode);
            if (eventTemplate.requiresTransaction()) {
                Objects.requireNonNull(this.transactionOperations);
                return (String)this.transactionOperations.execute(session -> (String)expander.get());
            }
            return expander.get();
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getEventHost(Event event) {
        if (event.getHost() == null) {
            return null;
        }
        if (!event.hasNodeid()) {
            return event.getHost();
        }
        try {
            return this.getHostName(event.getNodeid().intValue(), event.getHost());
        }
        catch (Throwable t) {
            LOG.warn("Error converting host IP \"{}\" to a hostname, storing the IP.", (Object)event.getHost(), (Object)t);
            return event.getHost();
        }
    }

    @Override
    public ExpandableParameterResolver getResolver(String token) {
        return this.resolverRegistry.getResolver(token);
    }

    @Override
    public Date decodeSnmpV2TcDateAndTime(BigInteger octetStringValue) {
        BigInteger offsetM;
        BigInteger offsetH;
        BigInteger offsetD;
        BigInteger millis;
        BigInteger sec;
        BigInteger min;
        BigInteger hour;
        BigInteger dom;
        BigInteger month;
        BigInteger year;
        int offsetMultiplier = 1;
        octetStringValue.bitCount();
        if (octetStringValue.bitLength() == 59) {
            year = octetStringValue.and(new BigInteger("ffff000000000000", 16)).shiftRight(48);
            month = octetStringValue.and(new BigInteger("0000ff0000000000", 16)).shiftRight(40).subtract(BigInteger.valueOf(1L));
            dom = octetStringValue.and(new BigInteger("000000ff00000000", 16)).shiftRight(32);
            hour = octetStringValue.and(new BigInteger("00000000ff000000", 16)).shiftRight(24);
            min = octetStringValue.and(new BigInteger("0000000000ff0000", 16)).shiftRight(16);
            sec = octetStringValue.and(new BigInteger("000000000000ff00", 16)).shiftRight(8);
            millis = octetStringValue.and(new BigInteger("00000000000000ff", 16)).multiply(BigInteger.valueOf(100L));
            offsetD = new BigInteger("2b", 16);
            offsetH = BigInteger.valueOf(0L);
            offsetM = BigInteger.valueOf(0L);
        } else if (octetStringValue.bitLength() == 83) {
            year = octetStringValue.and(new BigInteger("ffff000000000000000000", 16)).shiftRight(72);
            month = octetStringValue.and(new BigInteger("0000ff0000000000000000", 16)).shiftRight(64).subtract(BigInteger.valueOf(1L));
            dom = octetStringValue.and(new BigInteger("000000ff00000000000000", 16)).shiftRight(56);
            hour = octetStringValue.and(new BigInteger("00000000ff000000000000", 16)).shiftRight(48);
            min = octetStringValue.and(new BigInteger("0000000000ff0000000000", 16)).shiftRight(40);
            sec = octetStringValue.and(new BigInteger("000000000000ff00000000", 16)).shiftRight(32);
            millis = octetStringValue.and(new BigInteger("00000000000000ff000000", 16)).shiftRight(24).multiply(BigInteger.valueOf(100L));
            offsetD = octetStringValue.and(new BigInteger("0000000000000000ff0000", 16)).shiftRight(16);
            offsetH = octetStringValue.and(new BigInteger("000000000000000000ff00", 16)).shiftRight(8);
            offsetM = octetStringValue.and(new BigInteger("00000000000000000000ff", 16));
        } else {
            LOG.warn("Not sure what to do with the DateAndTime value '{}'. Using current time instead.");
            return null;
        }
        if (offsetD.intValueExact() == 45) {
            offsetMultiplier = -1;
        }
        BigInteger offsetMs = offsetH.multiply(BigInteger.valueOf(3600L));
        offsetMs.add(offsetM.multiply(BigInteger.valueOf(60L)));
        offsetMs.multiply(BigInteger.valueOf(1000L));
        offsetMs.multiply(BigInteger.valueOf(offsetMultiplier));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(1, year.intValue());
        cal.set(2, month.intValue());
        cal.set(5, dom.intValue());
        cal.set(11, hour.intValue());
        cal.set(12, min.intValue());
        cal.set(13, sec.intValue());
        cal.set(14, millis.intValue());
        cal.set(15, offsetMs.intValue());
        return cal.getTime();
    }
}

