/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.LikeRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.HwEntityDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.eventd.AbstractEventUtil;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsHwEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class EventUtilDaoImpl
extends AbstractEventUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EventUtilDaoImpl.class);
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private SnmpInterfaceDao snmpInterfaceDao;
    @Autowired
    private AssetRecordDao assetRecordDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Autowired
    private HwEntityDao hwEntityDao;
    private final Pattern ASSET_PARM_PATTERN = Pattern.compile("^asset\\[(.*)\\]$");
    private final Pattern HW_PARM_PATTERN = Pattern.compile("^hardware\\[(.*):(.*)\\]$");
    private static final Map<String, PropertyDescriptor> assetDescriptorsByName = EventUtilDaoImpl.getDescriptorsForStrings(OnmsAssetRecord.class);
    private static final Map<String, PropertyDescriptor> hwEntityDescriptorsByName = EventUtilDaoImpl.getDescriptorsForStrings(OnmsHwEntity.class);

    @Override
    protected String getNodeLabel(long nodeId) {
        return this.nodeDao.getLabelForId(Integer.valueOf((int)nodeId));
    }

    @Override
    protected String getIfAlias(long nodeId, String ipaddr) {
        OnmsIpInterface iface = this.ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf((int)nodeId), ipaddr);
        if (iface != null && iface.getSnmpInterface() != null) {
            return iface.getSnmpInterface().getIfAlias();
        }
        return null;
    }

    @Override
    protected String getAssetFieldValue(String parm, long nodeId) {
        Matcher matcher = this.ASSET_PARM_PATTERN.matcher(parm);
        if (!matcher.matches()) {
            LOG.warn("Unsupported asset field parameter '{}'.", (Object)parm);
            return null;
        }
        String assetField = matcher.group(1).toLowerCase();
        OnmsAssetRecord assetRecord = this.assetRecordDao.findByNodeId(Integer.valueOf((int)nodeId));
        if (assetRecord == null) {
            return null;
        }
        return EventUtilDaoImpl.getStringPropertyByName(assetField, assetRecord, assetDescriptorsByName);
    }

    @Override
    public String getHardwareFieldValue(String parm, long nodeId) {
        Matcher matcher = this.HW_PARM_PATTERN.matcher(parm);
        if (!matcher.matches()) {
            LOG.warn("Unsupported hardware field parameter '{}'.", (Object)parm);
            return null;
        }
        String hwFieldSelector = matcher.group(1);
        String hwField = matcher.group(2).toLowerCase();
        if (hwFieldSelector.startsWith("~")) {
            String likeQuery = hwFieldSelector.substring(1);
            LOG.debug("Retrieving hardware field value {} on {} with like query {}", new Object[]{parm, nodeId, likeQuery});
            Criteria criteria = new Criteria(OnmsHwEntity.class).setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new EqRestriction("node.id", (Object)((int)nodeId))).addRestriction((Restriction)new LikeRestriction("entPhysicalName", (Object)likeQuery)).setOrders(Arrays.asList(Order.desc((String)"id")));
            List hwEntities = this.hwEntityDao.findMatching(criteria);
            System.err.println(hwEntities);
            if (hwEntities.size() < 1) {
                return null;
            }
            return EventUtilDaoImpl.getStringPropertyByName(hwField, hwEntities.get(0), hwEntityDescriptorsByName);
        }
        try {
            int index = Integer.parseInt(hwFieldSelector);
            OnmsHwEntity hwEntity = this.hwEntityDao.findEntityByIndex(Integer.valueOf((int)nodeId), Integer.valueOf(index));
            if (hwEntity == null) {
                return null;
            }
            return EventUtilDaoImpl.getStringPropertyByName(hwField, hwEntity, hwEntityDescriptorsByName);
        }
        catch (NumberFormatException index) {
            OnmsHwEntity hwEntity = this.hwEntityDao.findEntityByName(Integer.valueOf((int)nodeId), hwFieldSelector);
            if (hwEntity == null) {
                return null;
            }
            return EventUtilDaoImpl.getStringPropertyByName(hwField, hwEntity, hwEntityDescriptorsByName);
        }
    }

    @Override
    public String getHostName(int nodeId, String hostip) {
        OnmsIpInterface ints = this.ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf(nodeId), hostip);
        if (ints == null) {
            return hostip;
        }
        String hostname = ints.getIpHostName();
        return hostname == null ? hostip : hostname;
    }

    @Override
    @Transactional(readOnly=true)
    public String expandParms(String inp, Event event) {
        return super.expandParms(inp, event, null);
    }

    @Override
    @Transactional(readOnly=true)
    public String expandParms(String inp, Event event, Map<String, Map<String, String>> decode) {
        return super.expandParms(inp, event, decode);
    }

    private static String getStringPropertyByName(String name, Object bean, Map<String, PropertyDescriptor> map) {
        PropertyDescriptor propertyDescr = map.get(name);
        if (propertyDescr == null) {
            return null;
        }
        try {
            return (String)PropertyUtils.getProperty((Object)bean, (String)propertyDescr.getName());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Retrieving propery {} on {} by name failed.", (Object)propertyDescr, bean);
            return null;
        }
    }

    private static Map<String, PropertyDescriptor> getDescriptorsForStrings(Class<?> clazz) {
        HashMap<String, PropertyDescriptor> descriptorsByName = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : PropertyUtils.getPropertyDescriptors(clazz)) {
            if (pd.getPropertyType() != String.class) continue;
            descriptorsByName.put(pd.getName().toLowerCase(), pd);
        }
        return descriptorsByName;
    }
}

