/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.IForward;

public final class ImmutableForward
implements IForward {
    private final String content;
    private final String state;
    private final String mechanism;

    private ImmutableForward(Builder builder) {
        this.content = builder.content;
        this.state = builder.state;
        this.mechanism = builder.mechanism;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IForward forward) {
        return new Builder(forward);
    }

    public static IForward immutableCopy(IForward forward) {
        if (forward == null || forward instanceof ImmutableForward) {
            return forward;
        }
        return ImmutableForward.newBuilderFrom(forward).build();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getMechanism() {
        return this.mechanism;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableForward that = (ImmutableForward)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.state, that.state) && Objects.equals(this.mechanism, that.mechanism);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.state, this.mechanism);
    }

    public String toString() {
        return "ImmutableForward{content='" + this.content + '\'' + ", state='" + this.state + '\'' + ", mechanism='" + this.mechanism + '\'' + '}';
    }

    public static final class Builder {
        private String content;
        private String state;
        private String mechanism;

        private Builder() {
        }

        public Builder(IForward forward) {
            this.content = forward.getContent();
            this.state = forward.getState();
            this.mechanism = forward.getMechanism();
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public Builder setMechanism(String mechanism) {
            this.mechanism = mechanism;
            return this;
        }

        public ImmutableForward build() {
            return new ImmutableForward(this);
        }
    }
}

