/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.persistence.impl;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.persistence.api.IpNetToMediaDao;

public class IpNetToMediaDaoHibernate
extends AbstractDaoHibernate<IpNetToMedia, Integer>
implements IpNetToMediaDao {
    public IpNetToMediaDaoHibernate() {
        super(IpNetToMedia.class);
    }

    public List<IpNetToMedia> findBySourceNodeId(Integer id) {
        return this.find("from IpNetToMedia rec where rec.sourceNode.id = ?", new Object[]{id});
    }

    public IpNetToMedia getByNetAndPhysAddress(InetAddress netAddress, String physAddress) {
        return (IpNetToMedia)this.findUnique("from IpNetToMedia rec where rec.netAddress = ? and rec.physAddress = ?", new Object[]{netAddress, physAddress});
    }

    public void deleteBySourceNodeIdOlderThen(Integer nodeId, Date now) {
        for (IpNetToMedia elem : this.find("from IpNetToMedia rec where rec.sourceNode.id = ? and rec.lastPollTime < ?", new Object[]{nodeId, now})) {
            this.delete(elem);
        }
    }

    public void deleteBySourceNodeId(Integer nodeId) {
        for (IpNetToMedia elem : this.find("from IpNetToMedia rec where rec.sourceNode.id = ? ", new Object[]{nodeId})) {
            this.delete(elem);
        }
    }

    public List<IpNetToMedia> findByPhysAddress(String physAddress) {
        return this.find("from IpNetToMedia rec where rec.physAddress = ?", new Object[]{physAddress});
    }

    public List<IpNetToMedia> findByNetAddress(InetAddress netAddress) {
        return this.find("from IpNetToMedia rec where rec.netAddress = ? ", new Object[]{netAddress});
    }
}

