/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.net.InetAddress;
import java.util.Optional;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.ReadOnlyEntity;

@ReadOnlyEntity
public class IpInterfaceTopologyEntity {
    private final Integer id;
    private final InetAddress ipAddress;
    private final String isManaged;
    private final PrimaryType isSnmpPrimary;
    private final Integer nodeId;
    private final Integer snmpInterfaceId;

    public IpInterfaceTopologyEntity(Integer id, InetAddress ipAddress, String isManaged, PrimaryType isSnmpPrimary, Integer nodeId, Integer snmpInterfaceId) {
        this.id = id;
        this.ipAddress = ipAddress;
        this.isManaged = isManaged;
        this.isSnmpPrimary = isSnmpPrimary;
        this.nodeId = nodeId;
        this.snmpInterfaceId = snmpInterfaceId;
    }

    public static IpInterfaceTopologyEntity create(OnmsIpInterface ipInterface) {
        return new IpInterfaceTopologyEntity(ipInterface.getId(), ipInterface.getIpAddress(), ipInterface.getIsManaged(), ipInterface.getIsSnmpPrimary(), Optional.ofNullable(ipInterface.getNode()).map(OnmsNode::getId).orElse(null), Optional.ofNullable(ipInterface.getSnmpInterface()).map(OnmsSnmpInterface::getId).orElse(null));
    }

    public Integer getId() {
        return this.id;
    }

    public String getNodeIdAsString() {
        if (this.getNodeId() != null) {
            return this.getNodeId().toString();
        }
        return null;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public String getIsManaged() {
        return this.isManaged;
    }

    public boolean isManaged() {
        return "M".equals(this.getIsManaged());
    }

    public PrimaryType getIsSnmpPrimary() {
        return this.isSnmpPrimary;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public Integer getSnmpInterfaceId() {
        return this.snmpInterfaceId;
    }

    public String toString() {
        return "IpInterfaceTopologyEntity{id=" + this.id + ", ipAddress=" + this.ipAddress + ", isManaged='" + this.isManaged + '\'' + ", isSnmpPrimary=" + this.isSnmpPrimary + ", nodeId=" + this.nodeId + ", snmpInterfaceId=" + this.snmpInterfaceId + '}';
    }
}

