/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.ErrorStatus;
import org.opennms.netmgt.snmp.ErrorStatusException;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OspfGeneralGroupTracker
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(OspfGeneralGroupTracker.class);
    public static final String OSPF_ROUTER_ID_ALIAS = "ospfRouterId";
    public static final String OSPF_ROUTER_ID_OID = ".1.3.6.1.2.1.14.1.1";
    public static final String OSPF_ADMIN_STAT_ALIAS = "ospfAdminStat";
    public static final String OSPF_ADMIN_STAT_OID = ".1.3.6.1.2.1.14.1.2";
    public static final String OSPF_VERSION_NUMBER_ALIAS = "ospfVersionNumber";
    public static final String OSPF_VERSION_NUMBER_OID = ".1.3.6.1.2.1.14.1.3";
    public static final String OSPF_AREA_BDR_RTR_STATUS_ALIAS = "ospfAreaBdrRtrStatus";
    public static final String OSPF_AREA_BDR_RTR_STATUS_OID = ".1.3.6.1.2.1.14.1.4";
    public static final String OSPF_AREA_AS_BDR_RTR_STATUS_ALIAS = "ospfAreaASBdrRtrStatus";
    public static final String OSPF_AREA_AS_BDR_RTR_STATUS_OID = ".1.3.6.1.2.1.14.1.5";
    public static NamedSnmpVar[] ms_elemList = null;
    public static final String OSPF_GENERAL_GROUP_OID = ".1.3.6.1.2.1.14.1";
    private SnmpStore m_store = new SnmpStore(ms_elemList);

    public OspfGeneralGroupTracker() {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
    }

    public InetAddress getOspfRouterId() {
        return this.m_store.getIPAddress(OSPF_ROUTER_ID_ALIAS);
    }

    public Integer getOspfASBdrRtrStatus() {
        return this.m_store.getInt32(OSPF_AREA_AS_BDR_RTR_STATUS_ALIAS);
    }

    public Integer getOspfBdrRtrStatus() {
        return this.m_store.getInt32(OSPF_AREA_BDR_RTR_STATUS_ALIAS);
    }

    public Integer getOspfVersionNumber() {
        return this.m_store.getInt32(OSPF_VERSION_NUMBER_ALIAS);
    }

    public Integer getOspfAdminStat() {
        return this.m_store.getInt32(OSPF_ADMIN_STAT_ALIAS);
    }

    public OspfElement getOspfElement() {
        OspfElement ospfElement = new OspfElement();
        ospfElement.setOspfRouterId(this.getOspfRouterId());
        ospfElement.setOspfAdminStat(OspfElement.Status.get((Integer)this.getOspfAdminStat()));
        ospfElement.setOspfVersionNumber(this.getOspfVersionNumber());
        ospfElement.setOspfBdrRtrStatus(OspfElement.TruthValue.get((Integer)this.getOspfBdrRtrStatus()));
        ospfElement.setOspfASBdrRtrStatus(OspfElement.TruthValue.get((Integer)this.getOspfASBdrRtrStatus()));
        return ospfElement;
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving OSPF general group: {}", (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving OSPF general group: {}", (Object)msg);
    }

    protected void reportFatalErr(ErrorStatusException ex) {
        LOG.warn("Error retrieving OSPF general group: {}", (Object)ex.getMessage(), (Object)ex);
    }

    protected void reportNonFatalErr(ErrorStatus status) {
        LOG.info("Non-fatal error ({}) retrieving OSPF general group: {}", (Object)status, (Object)(status.retry() ? "Retrying." : "Giving up."));
    }

    static {
        ms_elemList = new NamedSnmpVar[5];
        int ndx = 0;
        OspfGeneralGroupTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpIPAddress", OSPF_ROUTER_ID_ALIAS, OSPF_ROUTER_ID_OID);
        OspfGeneralGroupTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", OSPF_ADMIN_STAT_ALIAS, OSPF_ADMIN_STAT_OID);
        OspfGeneralGroupTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", OSPF_VERSION_NUMBER_ALIAS, OSPF_VERSION_NUMBER_OID);
        OspfGeneralGroupTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", OSPF_AREA_BDR_RTR_STATUS_ALIAS, OSPF_AREA_BDR_RTR_STATUS_OID);
        OspfGeneralGroupTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", OSPF_AREA_AS_BDR_RTR_STATUS_ALIAS, OSPF_AREA_AS_BDR_RTR_STATUS_OID);
    }
}

