/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.model.IsIsElement;
import org.opennms.netmgt.enlinkd.model.IsIsLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisCircTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(IsisCircTableTracker.class);
    public static final SnmpObjId ISIS_CIRC_TABLE = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.3.2");
    public static final SnmpObjId ISIS_CIRC_IFINDEX = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.3.2.1.2");
    public static final SnmpObjId ISIS_CIRC_ADMIN_STATE = SnmpObjId.get((String)".1.3.6.1.2.1.138.1.3.2.1.3");
    public static final SnmpObjId[] isisCirctable_elemList = new SnmpObjId[]{ISIS_CIRC_IFINDEX, ISIS_CIRC_ADMIN_STATE};

    public IsisCircTableTracker() {
        super(isisCirctable_elemList);
    }

    public IsisCircTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, isisCirctable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IsIsCircRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIsisCircRow((IsIsCircRow)row);
    }

    public void processIsisCircRow(IsIsCircRow row) {
    }

    public static class IsIsCircRow
    extends SnmpRowResult {
        public IsIsCircRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getIsisCircIndex() {
            return this.getInstance().getLastSubId();
        }

        public Integer getIsisCircIfIndex() {
            return this.getValue(ISIS_CIRC_IFINDEX).toInt();
        }

        public Integer getIsisCircAdminState() {
            return this.getValue(ISIS_CIRC_ADMIN_STATE).toInt();
        }

        public IsIsLink getIsisLink() {
            LOG.debug("getIsisLink: row count: {}", (Object)this.getColumnCount());
            IsIsLink link = new IsIsLink();
            link.setIsisCircIndex(this.getIsisCircIndex());
            link.setIsisCircIfIndex(this.getIsisCircIfIndex());
            link.setIsisCircAdminState(IsIsElement.IsisAdminState.get((Integer)this.getIsisCircAdminState()));
            LOG.debug("getIsisLink:Circ Index: {}, IS-IS Circ If Index: {}, Circ Admin State: {}", new Object[]{link.getIsisCircIndex(), link.getIsisCircIfIndex(), IsIsElement.IsisAdminState.getTypeString((Integer)this.getIsisCircAdminState())});
            return link;
        }
    }
}

