/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.model.CdpLink;
import org.opennms.netmgt.enlinkd.snmp.SnmpGetter;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;

public class CdpInterfacePortNameGetter
extends SnmpGetter {
    public static final SnmpObjId CDP_INTERFACE_NAME = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.1.1.1.6");
    public static final SnmpObjId MIB2_INTERFACE_NAME = SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.2");

    public CdpInterfacePortNameGetter(SnmpAgentConfig peer, LocationAwareSnmpClient client, String location, Integer nodeid) {
        super(peer, client, location, nodeid);
    }

    public CdpLink get(CdpLink link) {
        SnmpValue ifName = this.getInterfaceNameFromCiscoCdpMib(link.getCdpCacheIfIndex());
        if (ifName == null) {
            ifName = this.getInterfaceNameFromMib2(link.getCdpCacheIfIndex());
        }
        if (ifName != null) {
            link.setCdpInterfaceName(ifName.toDisplayString());
        }
        return link;
    }

    public SnmpValue getInterfaceNameFromCiscoCdpMib(Integer ifindex) {
        return this.get(CDP_INTERFACE_NAME, ifindex);
    }

    public SnmpValue getInterfaceNameFromMib2(Integer ifindex) {
        return this.get(MIB2_INTERFACE_NAME, ifindex);
    }
}

