/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.model.VlanStatus;
import org.opennms.netmgt.enlinkd.model.VlanType;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;

public class CiscoVtpVlanTableTracker
extends TableTracker {
    public static final SnmpObjId CISCO_VTP_VLAN_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.46.1.3.1.1");
    public static final SnmpObjId CISCO_VTP_VLAN_STATE = SnmpObjId.get((SnmpObjId)CISCO_VTP_VLAN_TABLE_ENTRY, (String)"2");
    public static final SnmpObjId CISCO_VTP_VLAN_TYPE = SnmpObjId.get((SnmpObjId)CISCO_VTP_VLAN_TABLE_ENTRY, (String)"3");
    public static final SnmpObjId CISCO_VTP_VLAN_NAME = SnmpObjId.get((SnmpObjId)CISCO_VTP_VLAN_TABLE_ENTRY, (String)"4");
    public static SnmpObjId[] cisco_vlan_elemList = new SnmpObjId[]{CISCO_VTP_VLAN_STATE, CISCO_VTP_VLAN_TYPE, CISCO_VTP_VLAN_NAME};

    public CiscoVtpVlanTableTracker() {
        super(cisco_vlan_elemList);
    }

    public CiscoVtpVlanTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, cisco_vlan_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new CiscoVtpVlanRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processCiscoVtpVlanRow((CiscoVtpVlanRow)row);
    }

    public void processCiscoVtpVlanRow(CiscoVtpVlanRow row) {
    }

    public static class CiscoVtpVlanRow
    extends SnmpRowResult {
        public CiscoVtpVlanRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public VlanStatus getVlanStatus() {
            return VlanStatus.get((Integer)this.getValue(CISCO_VTP_VLAN_STATE).toInt());
        }

        public VlanType getVlanType() {
            return VlanType.get((Integer)this.getValue(CISCO_VTP_VLAN_TYPE).toInt());
        }

        public Integer getVlanIndex() {
            return this.getInstance().getLastSubId();
        }

        public String getVlanName() {
            return this.getValue(CISCO_VTP_VLAN_NAME).toDisplayString();
        }

        public boolean isStatusOperational() {
            return this.getVlanStatus().equals((Object)VlanStatus.CISCOVTP_OPERATIONAL);
        }

        public boolean isTypeEthernet() {
            return this.getVlanType().equals((Object)VlanType.CISCO_VTP_ETHERNET);
        }
    }
}

