/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.ErrorStatusException;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CiscoVtpTracker
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CiscoVtpTracker.class);
    public static final String VTP_VERSION = "vtpVersion";
    public static final NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVersion", ".1.3.6.1.4.1.9.9.46.1.1.1")};
    private SnmpStore m_store = new SnmpStore(ms_elemList);

    public CiscoVtpTracker() {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving vtpVersion: {}", (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving vtpVersion: {}", (Object)msg);
    }

    protected void reportFatalErr(ErrorStatusException ex) {
        LOG.warn("Error retrieving vtpVersion: {}", (Object)ex.getMessage(), (Object)ex);
    }

    public Integer getVtpVersion() {
        return this.m_store.getInt32(VTP_VERSION);
    }
}

