/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.common.NodeCollector;
import org.opennms.netmgt.enlinkd.model.BridgeElement;
import org.opennms.netmgt.enlinkd.model.BridgeStpLink;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpTracker;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpVlanTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBasePortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBaseTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dStpPortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dTpFdbTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1qTpFdbTableTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryBridge
extends NodeCollector {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryBridge.class);
    private final BridgeTopologyService m_bridgeTopologyService;
    private final int m_maxSize;
    private final boolean m_disableBridgeVlanDiscovery;

    public NodeDiscoveryBridge(BridgeTopologyService bridgeTopologyService, int maxSize, LocationAwareSnmpClient locationAwareSnmpClient, long interval, long initial, Node node, boolean disableBridgeVlanDiscovery) {
        super(locationAwareSnmpClient, interval, initial, node);
        this.m_bridgeTopologyService = bridgeTopologyService;
        this.m_maxSize = maxSize;
        this.m_disableBridgeVlanDiscovery = disableBridgeVlanDiscovery;
    }

    public void collect() {
        Date now = new Date();
        SnmpAgentConfig peer = this.getSnmpAgentConfig();
        String community = peer.getReadCommunity();
        Map<Object, Object> vlanmap = this.m_disableBridgeVlanDiscovery ? new HashMap() : this.getVtpVlanMap(peer);
        HashMap<Integer, SnmpAgentConfig> vlanSnmpAgentConfigMap = new HashMap<Integer, SnmpAgentConfig>();
        for (Integer n : vlanmap.keySet()) {
            LOG.debug("run: node [{}], support cisco vtp: setting peer community for vlan: {}, vlanname: {}", new Object[]{this.getNodeId(), n, vlanmap.get(n)});
            SnmpAgentConfig vlanpeer = this.getSnmpAgentConfig();
            if (vlanpeer.isVersion3()) {
                vlanpeer.setContextName("vlan-" + n);
            } else {
                vlanpeer.setReadCommunity(community + "@" + n);
            }
            vlanSnmpAgentConfigMap.put(n, vlanpeer);
        }
        if (vlanmap.isEmpty()) {
            vlanSnmpAgentConfigMap.put(null, peer);
            vlanmap.put(null, null);
        }
        List<BridgeForwardingTableEntry> bft = new ArrayList<BridgeForwardingTableEntry>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Map.Entry entry : vlanSnmpAgentConfigMap.entrySet()) {
            Map<Integer, Integer> vlanbridgetoifindex = this.walkDot1dBasePortTable((SnmpAgentConfig)entry.getValue());
            LOG.debug("run: node: [{}], vlan: {}, bridge ifindex map {}", new Object[]{this.getNodeId(), vlanmap.get(entry.getKey()), vlanbridgetoifindex});
            hashMap.putAll(vlanbridgetoifindex);
        }
        for (Map.Entry<Object, Object> entry : vlanmap.entrySet()) {
            BridgeElement bridge = this.getDot1dBridgeBase((SnmpAgentConfig)vlanSnmpAgentConfigMap.get(entry.getKey()));
            if (bridge == null) {
                LOG.debug("run: node: [{}], vlan {}. no dot1d bridge data found. skipping other operations", (Object)this.getNodeId(), entry.getValue());
                continue;
            }
            bridge.setVlan((Integer)entry.getKey());
            bridge.setVlanname((String)vlanmap.get(entry.getKey()));
            this.m_bridgeTopologyService.store(this.getNodeId(), bridge);
            if (!InetAddressUtils.isValidStpBridgeId((String)bridge.getStpDesignatedRoot())) {
                LOG.debug("run: node: [{}], vlan {}. invalid designated root: spanning tree not supported.", (Object)this.getNodeId(), entry.getValue());
            } else if (bridge.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)bridge.getStpDesignatedRoot()))) {
                LOG.debug("run: node [{}]: vlan {}. designated root {} is itself. Skipping store.", new Object[]{this.getNodeId(), entry.getValue(), bridge.getStpDesignatedRoot()});
            } else {
                for (BridgeStpLink stplink : this.walkSpanningTree((SnmpAgentConfig)vlanSnmpAgentConfigMap.get(entry.getKey()), bridge.getBaseBridgeAddress())) {
                    stplink.setVlan((Integer)entry.getKey());
                    stplink.setStpPortIfIndex((Integer)hashMap.get(stplink.getStpPort()));
                    this.m_bridgeTopologyService.store(this.getNodeId(), stplink);
                }
            }
            bft = this.walkDot1dTpFdp((String)entry.getValue(), (Integer)entry.getKey(), hashMap, bft, (SnmpAgentConfig)vlanSnmpAgentConfigMap.get(entry.getKey()));
        }
        LOG.debug("run: node [{}]: deleting older the time {}", (Object)this.getNodeId(), (Object)now);
        this.m_bridgeTopologyService.reconcile(this.getNodeId(), now);
        bft = this.walkDot1qTpFdb(peer, hashMap, bft);
        LOG.debug("run: node [{}]: bft size:{}", (Object)this.getNodeId(), (Object)bft.size());
        if (bft.size() > 0) {
            LOG.debug("run: node [{}]: updating topology", (Object)this.getNodeId());
            this.m_bridgeTopologyService.store(this.getNodeId(), bft);
        }
        this.m_bridgeTopologyService.collectedBft(this.getNodeId());
    }

    private BridgeElement getDot1dBridgeBase(SnmpAgentConfig peer) {
        Dot1dBaseTracker dot1dbase = new Dot1dBaseTracker();
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)dot1dbase).withDescription("dot1dbase").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: BRIDGE_MIB not supported: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return null;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: BRIDGE_MIB not supported: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return null;
        }
        BridgeElement bridge = dot1dbase.getBridgeElement();
        if (bridge.getBaseBridgeAddress() == null) {
            LOG.info("run: node [{}]: base bridge address is null. BRIDGE_MIB not supported.", (Object)this.getNodeId());
            return null;
        }
        if (!InetAddressUtils.isValidBridgeAddress((String)bridge.getBaseBridgeAddress())) {
            LOG.info("run: node [{}]: base bridge address {} is not valid on. BRIDGE_MIB not supported", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            return null;
        }
        if (bridge.getBaseNumPorts() == null) {
            LOG.debug("run: node [{}]: base bridge address {}: has null number port active. Setting to -1.", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            bridge.setBaseNumPorts(Integer.valueOf(-1));
        }
        LOG.debug("run: bridge {} has is if type {}, on: {}", new Object[]{dot1dbase.getBridgeAddress(), BridgeElement.BridgeDot1dBaseType.getTypeString((Integer)dot1dbase.getBridgeType()), this.getNodeId()});
        if (bridge.getBaseType() == null) {
            LOG.debug("run: node [{}]: base bridge address {}: has null base type. Setting to unknown.", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            bridge.setBaseType(BridgeElement.BridgeDot1dBaseType.DOT1DBASETYPE_UNKNOWN);
        }
        if (bridge.getBaseType() == BridgeElement.BridgeDot1dBaseType.DOT1DBASETYPE_SOURCEROUTE_ONLY) {
            LOG.info("run: node [{}]: base bridge address {}: is source route bridge only. BRIDGE_MIB not supported", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            return null;
        }
        return bridge;
    }

    private Map<Integer, String> getVtpVlanMap(SnmpAgentConfig peer) {
        final HashMap<Integer, String> vlanmap = new HashMap<Integer, String>();
        CiscoVtpTracker vtpStatus = new CiscoVtpTracker();
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)vtpStatus).withDescription("vtpVersion").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: vtpVersion: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return vlanmap;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: vtpVersion: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return vlanmap;
        }
        if (vtpStatus.getVtpVersion() == null) {
            LOG.debug("run: node [{}]: cisco vtp mib not supported.", (Object)this.getNodeId());
            return vlanmap;
        }
        LOG.debug("run: node [{}]: cisco vtp mib supported.", (Object)this.getNodeId());
        CiscoVtpVlanTableTracker ciscoVtpVlanTableTracker = new CiscoVtpVlanTableTracker(){

            @Override
            public void processCiscoVtpVlanRow(CiscoVtpVlanTableTracker.CiscoVtpVlanRow row) {
                if (row.isTypeEthernet() && row.isStatusOperational()) {
                    vlanmap.put(row.getVlanIndex(), row.getVlanName());
                }
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ciscoVtpVlanTableTracker).withDescription("ciscoVtpVlan").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return vlanmap;
    }

    private Map<Integer, Integer> walkDot1dBasePortTable(SnmpAgentConfig peer) {
        final HashMap<Integer, Integer> bridgetoifindex = new HashMap<Integer, Integer>();
        Dot1dBasePortTableTracker dot1dBasePortTableTracker = new Dot1dBasePortTableTracker(){

            @Override
            public void processDot1dBasePortRow(Dot1dBasePortTableTracker.Dot1dBasePortRow row) {
                bridgetoifindex.put(row.getBaseBridgePort(), row.getBaseBridgePortIfindex());
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)dot1dBasePortTableTracker).withDescription("dot1dBasePortTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return bridgetoifindex;
    }

    private List<BridgeForwardingTableEntry> walkDot1dTpFdp(final String vlan, final Integer vlanId, final Map<Integer, Integer> bridgeifindex, final List<BridgeForwardingTableEntry> bft, SnmpAgentConfig peer) {
        Dot1dTpFdbTableTracker dot1dTpFdbTableTracker = new Dot1dTpFdbTableTracker(){

            @Override
            public void processDot1dTpFdbRow(Dot1dTpFdbTableTracker.Dot1dTpFdbRow row) {
                BridgeForwardingTableEntry link = row.getLink();
                if (link.getBridgeDot1qTpFdbStatus() == null) {
                    LOG.debug("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {}. row has null status. ", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort()});
                    return;
                }
                if (link.getBridgePort() == null) {
                    LOG.debug("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} status {}. row has null bridge port.  ", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (link.getMacAddress() == null || !InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress())) {
                    LOG.debug("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row has invalid mac.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                link.setVlan(vlanId);
                if (!bridgeifindex.containsKey(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    LOG.debug("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} status {}. no ifindex found. ", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgeDot1qTpFdbStatus()});
                    NodeDiscoveryBridge.this.fixCiscoBridgeMibPort(link.getBridgePort(), bridgeifindex);
                }
                link.setBridgePortIfIndex((Integer)bridgeifindex.get(link.getBridgePort()));
                LOG.debug("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row processed.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getVlan(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                bft.add(link);
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)dot1dTpFdbTableTracker).withDescription("dot1dTbFdbPortTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return bft;
    }

    private void fixCiscoBridgeMibPort(Integer bridgeport, Map<Integer, Integer> bridgeifindex) {
        ArrayList<Integer> sortedPort = new ArrayList<Integer>(bridgeifindex.keySet());
        Collections.sort(sortedPort);
        Integer beforePort = null;
        Integer afterPort = null;
        for (Integer port : sortedPort) {
            if (port < bridgeport) {
                beforePort = port;
            }
            if (port <= bridgeport) continue;
            afterPort = port;
            break;
        }
        if (afterPort == null && beforePort == null) {
            bridgeifindex.put(bridgeport, bridgeport);
        } else if (afterPort == null && bridgeifindex.get(beforePort) == 0) {
            bridgeifindex.put(bridgeport, bridgeport);
        } else if (beforePort == null && bridgeifindex.get(afterPort) == 0) {
            bridgeifindex.put(bridgeport, bridgeport);
        } else if (afterPort == null) {
            bridgeifindex.put(bridgeport, bridgeport + bridgeifindex.get(beforePort) - beforePort);
        } else if (beforePort == null) {
            bridgeifindex.put(bridgeport, bridgeport + bridgeifindex.get(afterPort) - afterPort);
        } else {
            int diffbefore = 0;
            int diffafter = 0;
            if (bridgeifindex.get(beforePort) != null) {
                diffbefore = bridgeifindex.get(beforePort) - beforePort;
            } else {
                LOG.error("fixCiscoBridgeMibPort: node [{}]:  null ifindex found for before port {}.", (Object)this.getNodeId(), (Object)beforePort);
            }
            if (bridgeifindex.get(afterPort) != null) {
                diffafter = bridgeifindex.get(afterPort) - afterPort;
            } else {
                LOG.error("fixCiscoBridgeMibPort: node [{}]:  null ifindex found for after port {}.", (Object)this.getNodeId(), (Object)afterPort);
            }
            if (diffafter == diffbefore) {
                bridgeifindex.put(bridgeport, bridgeport + diffafter);
            } else if (bridgeport - beforePort > afterPort - bridgeport) {
                bridgeifindex.put(bridgeport, diffafter + bridgeport);
            } else {
                bridgeifindex.put(bridgeport, diffbefore + bridgeport);
            }
        }
        LOG.debug("fixCiscoBridgeMibPort: node [{}]: port {} ifindex {}.", new Object[]{this.getNodeId(), bridgeport, bridgeifindex.get(bridgeport)});
    }

    private List<BridgeForwardingTableEntry> walkDot1qTpFdb(SnmpAgentConfig peer, final Map<Integer, Integer> bridgeifindex, final List<BridgeForwardingTableEntry> bft) {
        LOG.debug("walkDot1qTpFdb: node [{}]: bridge ifindex map {}", (Object)this.getNodeId(), bridgeifindex);
        Dot1qTpFdbTableTracker dot1qTpFdbTableTracker = new Dot1qTpFdbTableTracker(){

            @Override
            public void processDot1qTpFdbRow(Dot1qTpFdbTableTracker.Dot1qTpFdbRow row) {
                BridgeForwardingTableEntry link = row.getLink();
                if (link.getBridgeDot1qTpFdbStatus() == null) {
                    LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: on port {}. row has null status.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getBridgePort()});
                    return;
                }
                if (link.getBridgePort() == null) {
                    LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: on port {} status {}. row has null bridge port.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getBridgePort(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (link.getMacAddress() == null || !InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress())) {
                    LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. row has invalid mac.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (bridgeifindex.isEmpty() && link.getBridgeDot1qTpFdbStatus() != BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    link.setBridgePortIfIndex(link.getBridgePort());
                    LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. Empty map from bridgeport to ifindex. Assuming ifindex=bridgeport", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                } else if (!bridgeifindex.containsKey(link.getBridgePort()) && bridgeifindex.containsValue(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    for (Integer bridgeport : bridgeifindex.keySet()) {
                        if (link.getBridgePort().intValue() != ((Integer)bridgeifindex.get(bridgeport)).intValue()) continue;
                        link.setBridgePort(bridgeport);
                        link.setBridgePortIfIndex((Integer)bridgeifindex.get(bridgeport));
                    }
                    LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. Assument bridgeport index is ifindex. Reverting bridgeport/ifindex", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                } else {
                    if (!bridgeifindex.containsKey(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                        LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. Cnnot find suitable skipping entry", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                        return;
                    }
                    link.setBridgePortIfIndex((Integer)bridgeifindex.get(link.getBridgePort()));
                }
                LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row processed.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getVlan(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                bft.add(link);
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)dot1qTpFdbTableTracker).withDescription("dot1qTbFdbPortTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return bft;
    }

    private List<BridgeStpLink> walkSpanningTree(SnmpAgentConfig peer, final String baseBridgeAddress) {
        final ArrayList<BridgeStpLink> stplinks = new ArrayList<BridgeStpLink>();
        Dot1dStpPortTableTracker stpPortTableTracker = new Dot1dStpPortTableTracker(){

            @Override
            public void processDot1dStpPortRow(Dot1dStpPortTableTracker.Dot1dStpPortRow row) {
                BridgeStpLink link = row.getLink();
                LOG.debug("processDot1dStpPortRow: node [{}]: stp: port:{}/{}, vlan:{}, designated root/bridge/port:{}/{}/{}.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getStpPort(), link.getStpPortState(), link.getVlan(), link.getDesignatedRoot(), link.getDesignatedBridge(), link.getDesignatedPort()});
                if (InetAddressUtils.isValidStpBridgeId((String)link.getDesignatedRoot()) && InetAddressUtils.isValidStpBridgeId((String)link.getDesignatedBridge()) && !baseBridgeAddress.equals(link.getDesignatedBridgeAddress())) {
                    LOG.debug("processDot1dStpPortRow: node [{}]: stp: port:{}/{}, vlan:{}, designated root/bridge/port:{}/{}/{}. row added", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getStpPort(), link.getStpPortState(), link.getVlan(), link.getDesignatedRoot(), link.getDesignatedBridge(), link.getDesignatedPort()});
                    stplinks.add(link);
                }
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)stpPortTableTracker).withDescription("dot1dStpPortTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return stplinks;
    }

    public String getName() {
        return "NodeDiscoveryBridge";
    }

    public boolean isReady() {
        return this.m_bridgeTopologyService.collectBft(this.getNodeId(), this.m_maxSize);
    }
}

