/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.ServiceHolder;
import org.opennms.netmgt.dao.TestRegistry;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.dao.api.IfLabel;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.NodeLabel;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.dao.api.SessionFactoryWrapper;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.api.StatisticsService;
import org.opennms.netmgt.enlinkd.persistence.api.TopologyEntityCache;
import org.opennms.netmgt.enlinkd.persistence.api.TopologyEntityDao;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.OnmsNode;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionOperations;

public class DaoServiceTester {
    private static final Logger LOG = LoggerFactory.getLogger(DaoServiceTester.class);
    private static final Pattern SERVICE_PATTERN = Pattern.compile("<onmsgi:service.*interface[\\s]*=[\\s]*\"([\\w\\d\\.-]*)\".*\\/>");
    private final BundleContext bundleContext;
    private final TestRegistry testRegistry = new TestRegistry().withIgnoredClass(SessionUtils.class, SessionFactoryWrapper.class, TransactionOperations.class, PlatformTransactionManager.class, AlarmEntityNotifier.class, TopologyEntityDao.class, TopologyEntityCache.class).withTest(OnmsDao.class, dao -> dao.countAll()).withTest(BridgeTopologyService.class, bean -> bean.load()).withTest(AlarmRepository.class, bean -> bean.unacknowledgeAll("ulf")).withTest(IfLabel.class, bean -> bean.getIfLabel(1, InetAddressUtils.addr((String)"127.0.0.1"))).withTest(InterfaceToNodeCache.class, bean -> bean.dataSourceSync()).withTest(FilterDao.class, bean -> bean.getActiveIPAddressList("categoryName == 'Test'")).withTest(GenericPersistenceAccessor.class, bean -> bean.get(OnmsNode.class, (Serializable)Integer.valueOf(1))).withTest(NodeDao.class, bean -> bean.getDefaultFocusPoint()).withTest(StatisticsService.class, bean -> bean.getTotalCount(new CriteriaBuilder(OnmsNode.class).toCriteria())).withTest(NodeLabel.class, bean -> {
        try {
            bean.computeLabel(1);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    });

    public DaoServiceTester(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public void verifyExposedDaos() throws Exception {
        List<Class> serviceTypes = this.loadExposedServices("/META-INF/opennms/applicationContext-shared.xml", "/META-INF/opennms/component-dao.xml");
        if (serviceTypes.isEmpty()) {
            throw new IllegalStateException("No exposed services found. This seems fishy. Bailing");
        }
        for (Class eachServiceType : serviceTypes) {
            if (!this.testRegistry.isIgnored(eachServiceType)) {
                LOG.info("Verifying service {} ...", (Object)eachServiceType);
                Consumer consumer = this.testRegistry.getTest(eachServiceType);
                if (consumer == null) {
                    throw new IllegalStateException("No test for type " + eachServiceType + " was found. Bailing");
                }
                ServiceHolder serviceHolder = this.getService(eachServiceType);
                Throwable throwable = null;
                try {
                    Object service = serviceHolder.getService();
                    consumer.accept(service);
                    this.testRegistry.markAsRun(eachServiceType);
                    LOG.info("Verifying service {}. OK", (Object)eachServiceType);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (serviceHolder == null) continue;
                    if (throwable != null) {
                        try {
                            serviceHolder.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    serviceHolder.close();
                    continue;
                }
            }
            LOG.info("Verifying service {}. SKIPPED.", (Object)eachServiceType);
        }
        List<Class> notTestedServices = serviceTypes.stream().filter(e -> !this.testRegistry.isTested((Class)e) && !this.testRegistry.isIgnored((Class)e)).collect(Collectors.toList());
        if (!notTestedServices.isEmpty()) {
            notTestedServices.forEach(serviceType -> LOG.error("Service of type {} was not tested", serviceType));
            throw new IllegalStateException("Not all services have been tested. Bailing");
        }
    }

    private <T> ServiceHolder<T> getService(Class<T> serviceType) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(serviceType);
        if (serviceReference == null) {
            throw new IllegalStateException("Service of type '" + serviceType + "' not resolvable");
        }
        return new ServiceHolder(serviceReference);
    }

    private Bundle findDaoBundle() {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals("org.opennms.features.distributed.dao-impl")) continue;
            return b;
        }
        throw new IllegalStateException("No bundle with symbolic name 'org.opennms.features.distributed.dao-impl' found");
    }

    private List<Class> loadExposedServices(String ... locations) throws IOException, ClassNotFoundException {
        Bundle daoBundle = this.findDaoBundle();
        ArrayList<Class> entries = new ArrayList<Class>();
        for (String location : locations) {
            LOG.info("Bundle with id {} is used to load {}", (Object)daoBundle.getBundleId(), (Object)location);
            try (InputStream in = daoBundle.getResource(location).openStream();){
                byte[] bytes = ByteStreams.toByteArray((InputStream)in);
                String content = new String(bytes);
                Matcher m = SERVICE_PATTERN.matcher(content);
                while (m.find()) {
                    if (m.groupCount() < 1) continue;
                    String group = m.group(1);
                    LOG.info("Found exposed service {}. Try loading it...", (Object)group);
                    Class<?> clazz = Class.forName(group);
                    entries.add(clazz);
                }
            }
        }
        return entries;
    }
}

