/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgePortWithMacs;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.BroadcastDomain;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class SharedSegment
implements Topology {
    private Integer m_designatedBridgeId;
    private Set<String> m_macsOnSegment = new HashSet<String>();
    private Set<BridgePort> m_portsOnSegment = new HashSet<BridgePort>();
    private Date m_createTime;
    private Date m_lastPollTime;

    public static List<BridgeBridgeLink> getBridgeBridgeLinks(SharedSegment segment) throws BridgeTopologyException {
        return BridgeForwardingTableEntry.create(segment.getDesignatedPort(), segment.getBridgePortsOnSegment());
    }

    public static List<BridgeMacLink> getBridgeMacLinks(SharedSegment segment) throws BridgeTopologyException {
        return BridgeForwardingTableEntry.create(segment.getDesignatedPort(), segment.getMacsOnSegment(), BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
    }

    public static SharedSegment create(BridgeMacLink link) throws BridgeTopologyException {
        SharedSegment segment = new SharedSegment();
        segment.getBridgePortsOnSegment().add(BridgePort.getFromBridgeMacLink(link));
        segment.getMacsOnSegment().add(link.getMacAddress());
        segment.setDesignatedBridge(link.getNode().getId());
        segment.setCreateTime(link.getBridgeMacLinkCreateTime());
        segment.setLastPollTime(link.getBridgeMacLinkLastPollTime());
        return segment;
    }

    public static SharedSegment create(BridgeBridgeLink link) throws BridgeTopologyException {
        SharedSegment segment = new SharedSegment();
        segment.getBridgePortsOnSegment().add(BridgePort.getFromBridgeBridgeLink(link));
        segment.getBridgePortsOnSegment().add(BridgePort.getFromDesignatedBridgeBridgeLink(link));
        segment.setDesignatedBridge(link.getDesignatedNode().getId());
        segment.setCreateTime(link.getBridgeBridgeLinkCreateTime());
        segment.setLastPollTime(link.getBridgeBridgeLinkLastPollTime());
        return segment;
    }

    public static void merge(BroadcastDomain domain, SharedSegment upsegment, Map<BridgePortWithMacs, Set<BridgePortWithMacs>> splitted, Set<String> macsonsegment, BridgePort rootport, Set<BridgePortWithMacs> throughset) {
        splitted.keySet().stream().forEach(designated -> {
            Set ports = (Set)splitted.get(designated);
            SharedSegment splitsegment = new SharedSegment();
            splitsegment.getBridgePortsOnSegment().add(designated.getPort());
            splitsegment.setDesignatedBridge(designated.getPort().getNodeId());
            HashSet<String> macs = new HashSet<String>(designated.getMacs());
            ports.stream().forEach(bft -> {
                macs.retainAll(bft.getMacs());
                domain.cleanForwarders(bft.getPort().getNodeId());
                upsegment.getBridgePortsOnSegment().remove(bft.getPort());
                splitsegment.getBridgePortsOnSegment().add(bft.getPort());
            });
            splitsegment.getMacsOnSegment().addAll(macs);
            domain.getSharedSegments().add(splitsegment);
            domain.cleanForwarders(macs);
        });
        HashMap forfpmacs = new HashMap();
        upsegment.getBridgePortsOnSegment().stream().forEach(port -> {
            domain.getForwarders(port.getNodeId()).stream().filter(forward -> forward.getPort().equals(port)).forEach(forward -> forward.getMacs().stream().forEach(mac -> {
                int itemsfound = 1;
                if (forfpmacs.containsKey(mac)) {
                    itemsfound = (Integer)forfpmacs.get(mac);
                    ++itemsfound;
                }
                forfpmacs.put(mac, itemsfound);
            }));
            HashSet<String> clearmacs = new HashSet<String>();
            forfpmacs.keySet().stream().forEach(mac -> {
                if (((Integer)forfpmacs.get(mac)).intValue() == upsegment.getBridgePortsOnSegment().size()) {
                    upsegment.getMacsOnSegment().add((String)mac);
                    clearmacs.add((String)mac);
                }
            });
            domain.cleanForwarders(clearmacs);
        });
        upsegment.getBridgePortsOnSegment().add(rootport);
        upsegment.getMacsOnSegment().retainAll(macsonsegment);
        domain.cleanForwarders(upsegment.getMacsOnSegment());
        throughset.stream().forEach(bft -> SharedSegment.createAndAddToBroadcastDomain(domain, bft));
    }

    public static SharedSegment createAndAddToBroadcastDomain(BroadcastDomain domain, BridgePortWithMacs bft) {
        SharedSegment segment = new SharedSegment();
        segment.getBridgePortsOnSegment().add(bft.getPort());
        segment.getMacsOnSegment().addAll(bft.getMacs());
        segment.setDesignatedBridge(bft.getPort().getNodeId());
        domain.getSharedSegments().add(segment);
        domain.cleanForwarders(bft.getMacs());
        return segment;
    }

    public static SharedSegment create() {
        return new SharedSegment();
    }

    public Date getCreateTime() {
        return this.m_createTime;
    }

    public void setCreateTime(Date createTime) {
        this.m_createTime = createTime;
    }

    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    public boolean setDesignatedBridge(Integer designatedBridge) {
        this.m_designatedBridgeId = designatedBridge;
        return true;
    }

    public Integer getDesignatedBridge() {
        return this.m_designatedBridgeId;
    }

    public BridgePort getDesignatedPort() throws BridgeTopologyException {
        if (this.m_designatedBridgeId == null) {
            throw new BridgeTopologyException("Designated Bridge NodeId cannot be null", this);
        }
        BridgePort designatedbridge = this.getBridgePort(this.m_designatedBridgeId);
        if (designatedbridge == null) {
            throw new BridgeTopologyException("Designated BridgePort cannot be null", this);
        }
        return designatedbridge;
    }

    public boolean isEmpty() {
        return this.m_portsOnSegment.isEmpty();
    }

    public Set<BridgePort> getBridgePortsOnSegment() {
        return this.m_portsOnSegment;
    }

    public boolean noMacsOnSegment() {
        return this.m_macsOnSegment.isEmpty();
    }

    public Set<Integer> getBridgeIdsOnSegment() {
        HashSet<Integer> nodes = new HashSet<Integer>();
        for (BridgePort link : this.m_portsOnSegment) {
            if (link == null || link.getNodeId() == null) continue;
            nodes.add(link.getNodeId());
        }
        return nodes;
    }

    public Set<String> getMacsOnSegment() {
        return this.m_macsOnSegment;
    }

    public boolean containsMac(String mac) {
        return this.m_macsOnSegment.contains(mac);
    }

    public BridgePort getBridgePort(Integer nodeid) throws BridgeTopologyException {
        if (nodeid == null) {
            return null;
        }
        for (BridgePort port : this.m_portsOnSegment) {
            if (port == null) {
                throw new BridgeTopologyException("Shared Segment: BridgePort cannot be null.", this);
            }
            if (port.getNodeId() == null) {
                throw new BridgeTopologyException("Shared Segment: BridgePort nodeid cannot be null.", this);
            }
            if (port.getBridgePort() == null) {
                throw new BridgeTopologyException("Shared Segment: BridgePort bridgeport cannot be null.", this);
            }
            if (port.getNodeId().intValue() != nodeid.intValue()) continue;
            return port;
        }
        return null;
    }

    public boolean containsPort(BridgePort port) {
        return this.m_portsOnSegment.contains(port);
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("segment -> designated bridge:[");
        strbfr.append(this.getDesignatedBridge());
        strbfr.append("]\n");
        for (BridgePort blink : this.m_portsOnSegment) {
            strbfr.append("        -> port:");
            if (blink == null) {
                strbfr.append("[null]");
            } else {
                strbfr.append(blink.printTopology());
            }
            strbfr.append("\n");
        }
        strbfr.append("        -> macs:");
        strbfr.append(this.getMacsOnSegment());
        return strbfr.toString();
    }
}

