/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Order;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceDao;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.springframework.orm.hibernate3.HibernateCallback;

public class BusinessServiceDaoImpl
extends AbstractDaoHibernate<BusinessServiceEntity, Long>
implements BusinessServiceDao {
    public BusinessServiceDaoImpl() {
        super(BusinessServiceEntity.class);
    }

    @Override
    public Set<BusinessServiceEntity> findParents(BusinessServiceEntity child) {
        final long childId = Objects.requireNonNull(child).getId();
        Set parents = (Set)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Set<BusinessServiceEntity>>(){

            public Set<BusinessServiceEntity> doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery("select edge from BusinessServiceEdgeEntity edge where type(edge) = BusinessServiceChildEdgeEntity and edge.child.id = :childId");
                query.setParameter("childId", (Object)childId);
                List list = query.list();
                return list.stream().map(BusinessServiceEdgeEntity::getBusinessService).collect(Collectors.toSet());
            }
        });
        return parents;
    }

    @Override
    public List<BusinessServiceEntity> findMatching(Criteria criteria) {
        HibernateCallback callback = session -> {
            if (criteria.getLimit() != null || criteria.getOffset() != null) {
                org.hibernate.Criteria idCriteria = this.m_criteriaConverter.convert(criteria, session);
                idCriteria.setProjection(Projections.distinct((Projection)Projections.projectionList().add((Projection)Projections.property((String)"id")).add((Projection)Projections.property((String)"name"))));
                List idList = idCriteria.list();
                if (!idList.isEmpty()) {
                    org.hibernate.Criteria entityCriteria = session.createCriteria(criteria.getCriteriaClass());
                    entityCriteria.add(Restrictions.in((String)"id", (Collection)idList.stream().map(e -> e[0]).collect(Collectors.toList())));
                    entityCriteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
                    for (Order eachOnmsOrder : criteria.getOrders()) {
                        if (eachOnmsOrder.asc()) {
                            entityCriteria.addOrder(org.hibernate.criterion.Order.asc((String)eachOnmsOrder.getAttribute()));
                            continue;
                        }
                        entityCriteria.addOrder(org.hibernate.criterion.Order.desc((String)eachOnmsOrder.getAttribute()));
                    }
                    return entityCriteria.list();
                }
                return Collections.emptyList();
            }
            org.hibernate.Criteria hibernateCriteria = this.m_criteriaConverter.convert(criteria, session);
            hibernateCriteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
            return hibernateCriteria.list();
        };
        return (List)this.getHibernateTemplate().execute(callback);
    }
}

