/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.enlinkd.model.BridgeBridgeLink;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgePortWithMacs;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.model.OnmsNode;

public class BridgeForwardingTableEntry
implements Topology {
    private Integer m_node;
    private Integer m_bridgePort;
    private Integer m_bridgePortIfIndex;
    private String m_macAddress;
    private Integer m_vlan;
    private BridgeDot1qTpFdbStatus m_status;

    public static String printTopology(Set<BridgeForwardingTableEntry> bft) {
        StringBuffer strbfr = new StringBuffer();
        boolean rn = false;
        for (BridgeForwardingTableEntry bftentry : bft) {
            if (rn) {
                strbfr.append("\n");
            } else {
                rn = true;
            }
            strbfr.append(bftentry.printTopology());
        }
        return strbfr.toString();
    }

    public static List<BridgeMacLink> create(BridgePortWithMacs bft, BridgeMacLink.BridgeMacLinkType type) {
        return BridgeForwardingTableEntry.create(bft.getPort(), bft.getMacs(), type);
    }

    public static List<BridgeMacLink> create(BridgePort bp, Set<String> macs, BridgeMacLink.BridgeMacLinkType type) {
        ArrayList<BridgeMacLink> maclinks = new ArrayList<BridgeMacLink>();
        macs.stream().forEach(mac -> maclinks.add(BridgeForwardingTableEntry.create(bp, mac, type)));
        return maclinks;
    }

    public static BridgeMacLink create(BridgePort bp, String macAddress, BridgeMacLink.BridgeMacLinkType type) {
        BridgeMacLink maclink = new BridgeMacLink();
        OnmsNode node = new OnmsNode();
        node.setId(bp.getNodeId());
        maclink.setNode(node);
        maclink.setBridgePort(bp.getBridgePort());
        maclink.setBridgePortIfIndex(bp.getBridgePortIfIndex());
        maclink.setMacAddress(macAddress);
        maclink.setVlan(bp.getVlan());
        maclink.setLinkType(type);
        return maclink;
    }

    public static List<BridgeBridgeLink> create(BridgePort designatedPort, Set<BridgePort> ports) {
        OnmsNode designatedNode = new OnmsNode();
        designatedNode.setId(designatedPort.getNodeId());
        ArrayList<BridgeBridgeLink> links = new ArrayList<BridgeBridgeLink>();
        for (BridgePort port : ports) {
            if (port.equals(designatedPort)) continue;
            BridgeBridgeLink link = new BridgeBridgeLink();
            OnmsNode node = new OnmsNode();
            node.setId(port.getNodeId());
            link.setNode(node);
            link.setBridgePort(port.getBridgePort());
            link.setBridgePortIfIndex(port.getBridgePortIfIndex());
            link.setVlan(port.getVlan());
            link.setDesignatedNode(designatedNode);
            link.setDesignatedPort(designatedPort.getBridgePort());
            link.setDesignatedPortIfIndex(designatedPort.getBridgePortIfIndex());
            link.setDesignatedVlan(designatedPort.getVlan());
            links.add(link);
        }
        return links;
    }

    public static Set<BridgeForwardingTableEntry> get(BridgePortWithMacs bft) {
        HashSet<BridgeForwardingTableEntry> bftentries = new HashSet<BridgeForwardingTableEntry>();
        bft.getMacs().stream().forEach(mac -> {
            BridgeForwardingTableEntry bftentry = new BridgeForwardingTableEntry();
            bftentry.setNodeId(bft.getPort().getNodeId());
            bftentry.setBridgePort(bft.getPort().getBridgePort());
            bftentry.setBridgePortIfIndex(bft.getPort().getBridgePortIfIndex());
            bftentry.setVlan(bft.getPort().getVlan());
            bftentry.setMacAddress((String)mac);
            bftentry.setBridgeDot1qTpFdbStatus(BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
            bftentries.add(bftentry);
        });
        return bftentries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BridgeForwardingTableEntry that = (BridgeForwardingTableEntry)o;
        return Objects.equals(this.m_node, that.m_node) && Objects.equals(this.m_bridgePort, that.m_bridgePort) && Objects.equals(this.m_macAddress, that.m_macAddress);
    }

    public int hashCode() {
        return Objects.hash(this.m_node, this.m_bridgePort, this.m_macAddress);
    }

    public Integer getNodeId() {
        return this.m_node;
    }

    public void setNodeId(Integer node) {
        this.m_node = node;
    }

    public Integer getBridgePort() {
        return this.m_bridgePort;
    }

    public void setBridgePort(Integer bridgePort) {
        this.m_bridgePort = bridgePort;
    }

    public Integer getBridgePortIfIndex() {
        return this.m_bridgePortIfIndex;
    }

    public void setBridgePortIfIndex(Integer bridgePortIfIndex) {
        this.m_bridgePortIfIndex = bridgePortIfIndex;
    }

    public String getMacAddress() {
        return this.m_macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.m_macAddress = macAddress;
    }

    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    public BridgeDot1qTpFdbStatus getBridgeDot1qTpFdbStatus() {
        return this.m_status;
    }

    public void setBridgeDot1qTpFdbStatus(BridgeDot1qTpFdbStatus status) {
        this.m_status = status;
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("[");
        strbfr.append(this.getMacAddress());
        strbfr.append(", bridge:[");
        strbfr.append(this.getNodeId());
        strbfr.append("], bridgeport:");
        strbfr.append(this.getBridgePort());
        strbfr.append(", ifindex:");
        strbfr.append(this.getBridgePortIfIndex());
        strbfr.append(", vlan:");
        strbfr.append(this.getVlan());
        if (this.getBridgeDot1qTpFdbStatus() != null) {
            strbfr.append(", status:");
            strbfr.append(BridgeDot1qTpFdbStatus.getTypeString(this.getBridgeDot1qTpFdbStatus().getValue()));
        }
        strbfr.append("]");
        return strbfr.toString();
    }

    public static enum BridgeDot1qTpFdbStatus {
        DOT1D_TP_FDB_STATUS_OTHER(1),
        DOT1D_TP_FDB_STATUS_INVALID(2),
        DOT1D_TP_FDB_STATUS_LEARNED(3),
        DOT1D_TP_FDB_STATUS_SELF(4),
        DOT1D_TP_FDB_STATUS_MGMT(5);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private BridgeDot1qTpFdbStatus(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return "other-vendor-specific";
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static BridgeDot1qTpFdbStatus get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create BridgeDot1qTpFdbStatus from null code");
            }
            if (code <= 0) {
                throw new IllegalArgumentException("Cannot create BridgeDot1qTpFdbStatus from" + code + " code");
            }
            switch (code) {
                case 1: {
                    return DOT1D_TP_FDB_STATUS_OTHER;
                }
                case 2: {
                    return DOT1D_TP_FDB_STATUS_INVALID;
                }
                case 3: {
                    return DOT1D_TP_FDB_STATUS_LEARNED;
                }
                case 4: {
                    return DOT1D_TP_FDB_STATUS_SELF;
                }
                case 5: {
                    return DOT1D_TP_FDB_STATUS_MGMT;
                }
            }
            throw new IllegalArgumentException("Cannot create BridgeDot1qTpFdbStatus from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "other");
            s_typeMap.put(2, "invalid");
            s_typeMap.put(3, "learned");
            s_typeMap.put(4, "self");
            s_typeMap.put(5, "mgmt");
        }
    }
}

