/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.web.internal;

import com.google.common.collect.Maps;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.opennms.features.datachoices.internal.StateManager;
import org.opennms.web.api.HtmlInjector;

public class ModalInjector
implements HtmlInjector {
    private StateManager m_stateManager;

    public String inject(HttpServletRequest request) throws TemplateException, IOException {
        if (ModalInjector.isPage("/opennms/admin/index.jsp", request)) {
            return ModalInjector.generateModalHtml(false);
        }
        if (this.m_stateManager.isEnabled() == null && ModalInjector.isPage("/opennms/index.jsp", request) && ModalInjector.isUserInAdminRole(request)) {
            return ModalInjector.generateModalHtml(true);
        }
        return null;
    }

    protected static String generateModalHtml(boolean showOnLoad) throws IOException, TemplateException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);
        ClassTemplateLoader ctl = new ClassTemplateLoader(ModalInjector.class, "/web");
        cfg.setTemplateLoader((TemplateLoader)ctl);
        Template template = cfg.getTemplate("modal.ftl.html");
        HashMap data = Maps.newHashMap();
        data.put("showOnLoad", showOnLoad);
        StringWriter out = new StringWriter();
        template.process((Object)data, (Writer)out);
        ((Writer)out).flush();
        return ((Object)out).toString();
    }

    protected static boolean isPage(String endOfUri, HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (uri == null) {
            return false;
        }
        return uri.endsWith(endOfUri);
    }

    protected static boolean isUserInAdminRole(HttpServletRequest request) {
        return request.isUserInRole("ROLE_ADMIN");
    }

    public void setStateManager(StateManager stateManager) {
        this.m_stateManager = stateManager;
    }
}

