/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.History;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.api.console.Signal;
import org.apache.karaf.shell.api.console.SignalListener;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.console.RegistryImpl;
import org.apache.karaf.shell.impl.console.parsing.CommandLineParser;
import org.apache.karaf.shell.support.ShellUtil;

public class HeadlessSessionImpl
implements Session {
    final Session parent;
    final Terminal terminal;
    final SessionFactory factory;
    final CommandSession session;
    final Registry registry;

    public HeadlessSessionImpl(SessionFactory factory, CommandProcessor processor, InputStream in, PrintStream out, PrintStream err) {
        this(factory, processor, in, out, err, null);
    }

    public HeadlessSessionImpl(SessionFactory factory, CommandProcessor processor, InputStream in, PrintStream out, PrintStream err, Session parent) {
        this.parent = parent;
        this.terminal = parent != null ? new ReadOnlyTerminal(parent.getTerminal()) : null;
        this.factory = factory;
        this.registry = new RegistryImpl(factory.getRegistry());
        this.registry.register(factory);
        this.registry.register(this);
        this.registry.register(this.registry);
        this.session = processor.createSession(in, out, err);
        if (parent == null) {
            Properties sysProps = System.getProperties();
            for (Object key : sysProps.keySet()) {
                this.session.put(key.toString(), sysProps.get(key));
            }
        }
        this.session.put(".processor", processor);
        this.session.put(".session", this);
        this.session.put(".commandSession", this.session);
        if (parent == null) {
            this.session.put("SCOPE", "shell:bundle:*");
            this.session.put("SUBSHELL", "");
            this.session.put("USER", ShellUtil.getCurrentUserName());
            this.session.put("APPLICATION", System.getProperty("karaf.name", "root"));
        }
        this.session.put("gogo.option.noglob", Boolean.TRUE);
        this.session.currentDir(Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize());
    }

    public CommandSession getSession() {
        return this.session;
    }

    @Override
    public Object execute(CharSequence commandline) throws Exception {
        String command = CommandLineParser.parse(this, commandline.toString());
        return this.session.execute(command);
    }

    @Override
    public Object get(String name) {
        Object val = this.session.get(name);
        if (val == null && this.parent != null) {
            val = this.parent.get(name);
        }
        return val;
    }

    @Override
    public void put(String name, Object value) {
        this.session.put(name, value);
    }

    @Override
    public InputStream getKeyboard() {
        return this.session.getKeyboard();
    }

    @Override
    public PrintStream getConsole() {
        return this.session.getConsole();
    }

    @Override
    public String readLine(String prompt, Character mask) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public History getHistory() {
        return null;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public SessionFactory getFactory() {
        return this.factory;
    }

    @Override
    public Path currentDir() {
        return this.session.currentDir();
    }

    @Override
    public void currentDir(Path path) {
        this.session.currentDir(path);
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String resolveCommand(String name) {
        if (!name.contains(":")) {
            String[] scopes = ((String)this.get("SCOPE")).split(":");
            List<Command> commands = this.registry.getCommands();
            for (String scope : scopes) {
                for (Command command : commands) {
                    if (!"*".equals(scope) && !command.getScope().equals(scope) || !command.getName().equals(name)) continue;
                    return command.getScope() + ":" + name;
                }
            }
        }
        return name;
    }

    @Override
    public void close() {
        this.session.close();
    }

    static class ReadOnlyTerminal
    implements Terminal {
        private final Terminal terminal;

        public ReadOnlyTerminal(Terminal terminal) {
            this.terminal = terminal;
        }

        @Override
        public String getType() {
            return this.terminal.getType();
        }

        @Override
        public int getWidth() {
            return this.terminal.getWidth();
        }

        @Override
        public int getHeight() {
            return this.terminal.getHeight();
        }

        @Override
        public boolean isAnsiSupported() {
            return this.terminal.isAnsiSupported();
        }

        @Override
        public boolean isEchoEnabled() {
            return this.terminal.isEchoEnabled();
        }

        @Override
        public void setEchoEnabled(boolean enabled) {
        }

        @Override
        public void addSignalListener(SignalListener listener, Signal ... signal) {
        }

        @Override
        public void addSignalListener(SignalListener listener, EnumSet<Signal> signals) {
        }

        @Override
        public void addSignalListener(SignalListener listener) {
        }

        @Override
        public void removeSignalListener(SignalListener listener) {
        }
    }
}

