/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.jmx.framework.BundleStateMBean;

public class BundleEventData {
    private long bundleId;
    private String location;
    private String bundleSymbolicName;
    private int eventType;

    private BundleEventData() {
    }

    public BundleEventData(BundleEvent bundleEvent) {
        this.eventType = bundleEvent.getType();
        Bundle bundle = bundleEvent.getBundle();
        this.bundleId = bundle.getBundleId();
        this.location = bundle.getLocation();
        this.bundleSymbolicName = bundle.getSymbolicName();
    }

    public CompositeData toCompositeData() {
        CompositeDataSupport result = null;
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.bundleId);
        items.put("SymbolicName", this.bundleSymbolicName);
        items.put("Location", this.location);
        items.put("BundleEvent", this.eventType);
        try {
            result = new CompositeDataSupport(BundleStateMBean.BUNDLE_EVENT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Failed to create CompositeData for BundleEvent for Bundle [" + this.bundleId + "]", e);
        }
        return result;
    }

    public static BundleEventData from(CompositeData compositeData) throws IllegalArgumentException {
        BundleEventData eventData = new BundleEventData();
        if (compositeData == null) {
            throw new IllegalArgumentException("Argument compositeData cannot be null");
        }
        if (!compositeData.getCompositeType().equals(BundleStateMBean.BUNDLE_EVENT_TYPE)) {
            throw new IllegalArgumentException("Invalid CompositeType [" + compositeData.getCompositeType() + "]");
        }
        eventData.bundleId = (Long)compositeData.get("Identifier");
        eventData.bundleSymbolicName = (String)compositeData.get("SymbolicName");
        eventData.eventType = (Integer)compositeData.get("BundleEvent");
        eventData.location = (String)compositeData.get("Location");
        return eventData;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public int getEventType() {
        return this.eventType;
    }
}

