/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Map;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.osgi.framework.BundleContext;

public class MDC {
    private static PaxContext m_context;
    private static PaxContext m_defaultContext;
    private static PaxLoggingManager m_paxLogging;

    public static void setBundleContext(BundleContext ctx) {
        m_paxLogging = new OSGIPaxLoggingManager(ctx);
        m_paxLogging.open();
    }

    private static boolean setContext() {
        if (m_context == null && m_paxLogging != null) {
            m_context = m_paxLogging.getPaxLoggingService() != null ? m_paxLogging.getPaxLoggingService().getPaxContext() : null;
        }
        return m_context != null;
    }

    public static void put(String key, Object o) {
        if (MDC.setContext()) {
            m_context.put(key, o);
        } else {
            m_defaultContext.put(key, o);
        }
    }

    public static Object get(String key) {
        if (MDC.setContext()) {
            return m_context.get(key);
        }
        return m_defaultContext.get(key);
    }

    public static void remove(String key) {
        if (MDC.setContext()) {
            m_context.remove(key);
        } else {
            m_defaultContext.remove(key);
        }
    }

    public static Map getContext() {
        if (MDC.setContext()) {
            return m_context.getContext();
        }
        return m_defaultContext.getContext();
    }

    public static void dispose() {
        m_paxLogging.close();
        m_paxLogging.dispose();
        m_paxLogging = null;
    }

    public static void clear() {
        if (MDC.setContext()) {
            m_context.clear();
        } else {
            m_defaultContext.clear();
        }
    }

    static {
        m_defaultContext = new PaxContext();
    }
}

