/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.url;

import aQute.bnd.url.DefaultURLConnectionHandler;
import aQute.lib.io.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsVerification
extends DefaultURLConnectionHandler {
    private SSLSocketFactory factory;
    private HostnameVerifier verifier;
    private final List<X509Certificate> certificates = new ArrayList<X509Certificate>();

    private synchronized void init() throws NoSuchAlgorithmException, KeyManagementException {
        if (this.factory == null) {
            final X509Certificate[] trusted = this.certificates.toArray(new X509Certificate[this.certificates.size()]);
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return trusted;
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                }
            }};
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, trustAllCerts, new SecureRandom());
            this.factory = context.getSocketFactory();
            this.verifier = new HostnameVerifier(){

                public boolean verify(String string, SSLSession session) {
                    return true;
                }
            };
        }
    }

    @Override
    public void handle(URLConnection connection) throws Exception {
        if (connection instanceof HttpsURLConnection && this.matches(connection)) {
            this.init();
            if (this.certificates.isEmpty()) {
                this.trace("Https verification for %s is DISABLED", connection.getURL());
            }
            HttpsURLConnection https = (HttpsURLConnection)connection;
            https.setSSLSocketFactory(this.factory);
            https.setHostnameVerifier(this.verifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Map<String, String> map) throws Exception {
        super.setProperties(map);
        String paths = map.get("trusted");
        if (paths != null) {
            for (String path : paths.split("\\s*,\\s*")) {
                File file = IO.getFile(path);
                if (!file.isFile()) continue;
                FileInputStream inStream = new FileInputStream(file);
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
                    this.certificates.add(cert);
                }
                finally {
                    ((InputStream)inStream).close();
                }
            }
        }
    }
}

