/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.config.command.completers.MetaCompleter;
import org.apache.karaf.config.core.impl.MetaServiceCaller;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.CommandException;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="config", name="meta", description="Lists meta type information.")
@Service
public class MetaCommand
extends ConfigCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MetaCommand.class);
    @Argument(name="pid", description="The configuration pid", required=true, multiValued=false)
    @Completion(value=MetaCompleter.class)
    protected String pid;
    @Option(name="-c", description="Create respective config from metatype defaults", required=false, multiValued=false)
    protected boolean create;
    @Reference
    BundleContext context;
    private Map<Integer, String> typeMap = new HashMap<Integer, String>();

    public MetaCommand() {
        this.typeMap.put(11, "boolean");
        this.typeMap.put(6, "byte");
        this.typeMap.put(5, "char");
        this.typeMap.put(7, "double");
        this.typeMap.put(8, "float");
        this.typeMap.put(3, "int");
        this.typeMap.put(2, "long");
        this.typeMap.put(12, "password");
        this.typeMap.put(4, "short");
        this.typeMap.put(1, "String");
    }

    @Override
    public Object doExecute() throws Exception {
        try {
            if (this.create) {
                MetaServiceCaller.withMetaTypeService(this.context, new Create());
            } else {
                MetaServiceCaller.withMetaTypeService(this.context, new Print());
            }
            return null;
        }
        catch (Throwable e) {
            Throwable ncdfe;
            for (ncdfe = e; ncdfe != null && !(ncdfe instanceof NoClassDefFoundError); ncdfe = ncdfe.getCause()) {
            }
            if (ncdfe != null && ncdfe.getMessage().equals("org/osgi/service/metatype/MetaTypeService")) {
                throw new CommandException("config:meta disabled because the org.osgi.service.metatype package is not wired", e);
            }
            throw e;
        }
    }

    class Print
    extends AbstractMeta {
        Print() {
        }

        @Override
        public Void apply(MetaTypeService metaTypeService) {
            ObjectClassDefinition def = this.getMetatype(metaTypeService, MetaCommand.this.pid);
            if (def == null) {
                System.out.println("No meta type definition found for pid: " + MetaCommand.this.pid);
                return null;
            }
            System.out.println("Meta type informations for pid: " + MetaCommand.this.pid);
            ShellTable table = new ShellTable();
            table.column("key");
            table.column("name");
            table.column("type");
            table.column("default");
            table.column("description").wrap();
            AttributeDefinition[] attrs = def.getAttributeDefinitions(-1);
            if (attrs != null) {
                for (AttributeDefinition attr : attrs) {
                    table.addRow().addContent(new Object[]{attr.getID(), attr.getName(), this.getType(attr.getType()), this.getDefaultValueStr(attr.getDefaultValue()), attr.getDescription()});
                }
            }
            table.print(System.out);
            return null;
        }

        private String getType(int type) {
            return (String)MetaCommand.this.typeMap.get(type);
        }
    }

    class Create
    extends AbstractMeta {
        Create() {
        }

        @Override
        public Void apply(MetaTypeService metaTypeService) {
            ObjectClassDefinition def = this.getMetatype(metaTypeService, MetaCommand.this.pid);
            if (def == null) {
                System.out.println("No meta type definition found for pid: " + MetaCommand.this.pid);
                return null;
            }
            try {
                this.createDefaultConfig(MetaCommand.this.pid, def);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }

        private void createDefaultConfig(String pid, ObjectClassDefinition def) throws IOException {
            AttributeDefinition[] attrs = def.getAttributeDefinitions(-1);
            if (attrs == null) {
                return;
            }
            Configuration config = MetaCommand.this.configRepository.getConfigAdmin().getConfiguration(pid);
            Hashtable<String, String> props = new Hashtable<String, String>();
            for (AttributeDefinition attr : attrs) {
                String valueStr = this.getDefaultValueStr(attr.getDefaultValue());
                if (valueStr == null) continue;
                ((Dictionary)props).put(attr.getID(), valueStr);
            }
            config.update(props);
        }
    }

    abstract class AbstractMeta
    implements Function<MetaTypeService, Void> {
        AbstractMeta() {
        }

        protected String getDefaultValueStr(String[] defaultValues) {
            if (defaultValues == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (String defaultValue : defaultValues) {
                if (first) {
                    first = false;
                } else {
                    result.append(",");
                }
                result.append(defaultValue);
            }
            return result.toString();
        }

        protected ObjectClassDefinition getMetatype(MetaTypeService metaTypeService, String pid) {
            for (Bundle bundle : MetaCommand.this.context.getBundles()) {
                String[] pids;
                MetaTypeInformation info = metaTypeService.getMetaTypeInformation(bundle);
                if (info == null) continue;
                for (String cPid : pids = info.getPids()) {
                    if (!cPid.equals(pid)) continue;
                    return info.getObjectClassDefinition(cPid, null);
                }
            }
            return null;
        }
    }
}

