/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.rrd;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.collection.api.ByNameComparator;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.NumericCollectionAttributeType;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.DefaultTimeKeeper;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistOperationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PersistOperationBuilder.class);
    private final RrdRepository m_repository;
    private final String m_rrdName;
    private final ResourceIdentifier m_resource;
    private final Map<CollectionAttributeType, String> m_declarations = new TreeMap<CollectionAttributeType, String>((Comparator<CollectionAttributeType>)new ByNameComparator());
    private final Map<String, String> m_metaData = new LinkedHashMap<String, String>();
    private TimeKeeper m_timeKeeper = new DefaultTimeKeeper();
    private static final String DST_GAUGE = "GAUGE";
    private static final String DST_COUNTER = "COUNTER";
    public static final int MAX_DS_NAME_LENGTH = 19;

    public PersistOperationBuilder(RrdRepository repository, ResourceIdentifier resource, String rrdName) {
        this.m_repository = repository;
        this.m_resource = resource;
        this.m_rrdName = rrdName;
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    private File getResourceDir(ResourceIdentifier resource) throws FileNotFoundException {
        return resource.getResourceDir(this.getRepository());
    }

    public void declareAttribute(CollectionAttributeType attrType) {
        this.m_declarations.put(attrType, "U");
    }

    public void setAttributeValue(CollectionAttributeType attrType, String value) {
        this.m_declarations.put(attrType, value);
    }

    public void setAttributeMetadata(String metricIdentifier, String name) {
        if (metricIdentifier == null) {
            if (name == null) {
                LOG.warn("Cannot set attribute metadata with null key and null value");
            } else {
                LOG.warn("Cannot set attribute metadata with null key and value of: {}", (Object)name);
            }
        } else {
            this.m_metaData.put(metricIdentifier, name);
        }
    }

    public static String mapType(String objectType) {
        if (objectType.toLowerCase().startsWith("counter")) {
            return DST_COUNTER;
        }
        if ("string".equalsIgnoreCase(objectType)) {
            return null;
        }
        if ("octetstring".equalsIgnoreCase(objectType)) {
            return null;
        }
        return DST_GAUGE;
    }

    public void commit() throws RrdException {
        if (this.m_declarations.size() == 0) {
            return;
        }
        try {
            String ownerName = this.m_resource.getOwnerName();
            String absolutePath = this.getResourceDir(this.m_resource).getAbsolutePath();
            List<RrdDataSource> dataSources = this.getDataSources();
            if (dataSources != null && dataSources.size() > 0) {
                RrdUtils.createRRD((String)ownerName, (String)absolutePath, (String)this.m_rrdName, (int)this.getRepository().getStep(), dataSources, (List)this.getRepository().getRraList(), this.getAttributeMappings());
                RrdUtils.updateRRD((String)ownerName, (String)absolutePath, (String)this.m_rrdName, (long)this.m_timeKeeper.getCurrentTime(), (String)this.getValues());
                RrdUtils.createMetaDataFile((String)absolutePath, (String)this.m_rrdName, this.m_metaData);
            }
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not get resource directory: " + e.getMessage(), (Throwable)e);
            return;
        }
    }

    private String getValues() {
        boolean first = true;
        StringBuffer values = new StringBuffer();
        for (CollectionAttributeType attrDef : this.m_declarations.keySet()) {
            String value = this.m_declarations.get(attrDef);
            if (!first) {
                values.append(':');
            } else {
                first = false;
            }
            values.append(value);
        }
        return values.toString();
    }

    private Map<String, String> getAttributeMappings() {
        return null;
    }

    private List<RrdDataSource> getDataSources() {
        ArrayList<RrdDataSource> dataSources = new ArrayList<RrdDataSource>(this.m_declarations.size());
        for (CollectionAttributeType attrDef : this.m_declarations.keySet()) {
            String type;
            String minval = "U";
            String maxval = "U";
            if (attrDef instanceof NumericCollectionAttributeType) {
                minval = ((NumericCollectionAttributeType)attrDef).getMinval() != null ? ((NumericCollectionAttributeType)attrDef).getMinval() : "U";
                String string = maxval = ((NumericCollectionAttributeType)attrDef).getMaxval() != null ? ((NumericCollectionAttributeType)attrDef).getMaxval() : "U";
            }
            if ((type = PersistOperationBuilder.mapType(attrDef.getType())) == null) continue;
            RrdDataSource rrdDataSource = new RrdDataSource(StringUtils.truncate((String)attrDef.getName(), (int)19), type, this.getRepository().getHeartBeat(), minval, maxval);
            dataSources.add(rrdDataSource);
        }
        return dataSources;
    }

    public String getName() {
        return this.m_rrdName;
    }

    public TimeKeeper getTimeKeeper() {
        return this.m_timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }
}

