/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.rrd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.NumericCollectionAttributeType;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.PersistOperationBuilder;
import org.opennms.netmgt.collection.support.AbstractCollectionSetVisitor;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePersister
extends AbstractCollectionSetVisitor
implements Persister {
    protected static final Logger LOG = LoggerFactory.getLogger(BasePersister.class);
    private boolean m_ignorePersist = false;
    private ServiceParameters m_params;
    private RrdRepository m_repository;
    private final LinkedList<Boolean> m_stack = new LinkedList();
    private PersistOperationBuilder m_builder;

    public BasePersister(ServiceParameters params, RrdRepository repository) {
        this.m_params = params;
        this.m_repository = repository;
    }

    public void commitBuilder() {
        if (this.isPersistDisabled()) {
            return;
        }
        String name = this.m_builder.getName();
        try {
            this.m_builder.commit();
            this.m_builder = null;
        }
        catch (RrdException e) {
            LOG.error("Unable to persist data for {}", (Object)name, (Object)e);
        }
    }

    private boolean isPersistDisabled() {
        return this.m_params != null && this.m_params.getParameters().containsKey("storing-enabled") && "false".equals(this.m_params.getParameters().get("storing-enabled"));
    }

    public void completeAttribute(CollectionAttribute attribute) {
        this.popShouldPersist();
    }

    public void completeGroup(AttributeGroup group) {
        this.popShouldPersist();
    }

    public void completeResource(CollectionResource resource) {
        this.popShouldPersist();
    }

    public void createBuilder(CollectionResource resource, String name, CollectionAttributeType attributeType) {
        this.createBuilder(resource, name, Collections.singleton(attributeType));
    }

    protected void createBuilder(CollectionResource resource, String name, Set<CollectionAttributeType> attributeTypes) {
        this.m_builder = new PersistOperationBuilder(this.getRepository(), (ResourceIdentifier)resource, name);
        if (resource.getTimeKeeper() != null) {
            this.m_builder.setTimeKeeper(resource.getTimeKeeper());
        }
        for (CollectionAttributeType attrType : attributeTypes) {
            if (!(attrType instanceof NumericCollectionAttributeType)) continue;
            this.m_builder.declareAttribute(attrType);
        }
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    public void setRepository(RrdRepository repository) {
        this.m_repository = repository;
    }

    public void persistNumericAttribute(CollectionAttribute attribute) {
        boolean persist = this.isIgnorePersist() && attribute.getType().toLowerCase().startsWith("counter");
        LOG.debug("Persisting {} {}", (Object)attribute, (Object)(persist ? ". Ignoring value because of sysUpTime changed." : ""));
        String value = persist ? "U" : attribute.getNumericValue();
        this.m_builder.setAttributeValue(attribute.getAttributeType(), value);
        this.m_builder.setAttributeMetadata(attribute.getMetricIdentifier(), attribute.getName());
    }

    public void persistStringAttribute(CollectionAttribute attribute) {
        LOG.debug("Persisting {}", (Object)attribute);
        CollectionResource resource = attribute.getResource();
        String value = attribute.getStringValue();
        if (value == null) {
            LOG.info("No data collected for attribute {}.  Skipping.", (Object)attribute);
            return;
        }
        String attrName = attribute.getName();
        try {
            File resourceDir = resource.getResourceDir(this.getRepository());
            ResourceTypeUtils.updateStringProperty((File)resourceDir, (String)value, (String)attrName);
        }
        catch (FileNotFoundException e) {
            LOG.error("Unable to save string attribute {}", (Object)attribute, (Object)e);
        }
        catch (IOException e) {
            LOG.error("Unable to save string attribute {}", (Object)attribute, (Object)e);
        }
    }

    public boolean popShouldPersist() {
        boolean top = this.top();
        this.m_stack.removeLast();
        return top;
    }

    private void push(boolean b) {
        this.m_stack.addLast(b);
    }

    public void pushShouldPersist(CollectionAttribute attribute) {
        this.pushShouldPersist(attribute.shouldPersist(this.m_params));
    }

    protected void pushShouldPersist(AttributeGroup group) {
        this.pushShouldPersist(group.shouldPersist(this.m_params));
    }

    private void pushShouldPersist(boolean shouldPersist) {
        this.push(this.top() && shouldPersist);
    }

    public void pushShouldPersist(CollectionResource resource) {
        this.push(resource.shouldPersist(this.m_params));
    }

    protected boolean shouldPersist() {
        return this.top();
    }

    public void storeAttribute(CollectionAttribute attribute) {
        if (this.shouldPersist()) {
            attribute.storeAttribute((Persister)this);
            LOG.debug("Storing attribute {}", (Object)attribute);
        } else {
            LOG.debug("Not persisting attribute {} because shouldPersist is false", (Object)attribute);
        }
    }

    private boolean top() {
        return this.m_stack.getLast();
    }

    public void visitAttribute(CollectionAttribute attribute) {
        this.pushShouldPersist(attribute);
        this.storeAttribute(attribute);
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
    }

    public void visitResource(CollectionResource resource) {
        LOG.info("Persisting data for resource {}", (Object)resource);
        this.pushShouldPersist(resource);
    }

    public boolean isIgnorePersist() {
        return this.m_ignorePersist;
    }

    public void setIgnorePersist(boolean ignore) {
        this.m_ignorePersist = ignore;
    }
}

