/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.rrd;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashMap;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.BasePersister;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;

public class GroupPersister
extends BasePersister {
    public GroupPersister(ServiceParameters params, RrdRepository repository) {
        super(params, repository);
    }

    @Override
    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
        if (this.shouldPersist()) {
            LinkedHashMap<String, String> dsNamesToRrdNames = new LinkedHashMap<String, String>();
            for (CollectionAttribute a : group.getAttributes()) {
                if (!ResourceTypeUtils.isNumericType((String)a.getType())) continue;
                dsNamesToRrdNames.put(a.getName(), group.getName());
            }
            this.createBuilder(group.getResource(), group.getName(), group.getGroupType().getAttributeTypes());
            try {
                File path = group.getResource().getResourceDir(this.getRepository());
                ResourceTypeUtils.updateDsProperties((File)path, dsNamesToRrdNames);
            }
            catch (FileNotFoundException e) {
                LOG.warn("Could not update datasource properties: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void completeGroup(AttributeGroup group) {
        if (this.shouldPersist()) {
            this.commitBuilder();
        }
        this.popShouldPersist();
    }
}

