/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support;

import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollectionAttribute
implements CollectionAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCollectionAttribute.class);
    protected final CollectionAttributeType m_attribType;
    protected final CollectionResource m_resource;

    public AbstractCollectionAttribute(CollectionAttributeType attribType, CollectionResource resource) {
        this.m_attribType = attribType;
        this.m_resource = resource;
    }

    @Override
    public final CollectionAttributeType getAttributeType() {
        return this.m_attribType;
    }

    @Override
    public final CollectionResource getResource() {
        return this.m_resource;
    }

    @Override
    public final String getName() {
        return this.m_attribType.getName();
    }

    @Override
    public final String getType() {
        return this.m_attribType.getType();
    }

    @Override
    public abstract String getNumericValue();

    @Override
    public abstract String getStringValue();

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    @Override
    public void storeAttribute(Persister persister) {
        this.getAttributeType().storeAttribute(this, persister);
    }

    @Override
    public final void visit(CollectionSetVisitor visitor) {
        LOG.debug("Visiting attribute {}", (Object)this);
        visitor.visitAttribute(this);
        visitor.completeAttribute(this);
    }
}

