/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.AbstractMapFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.AbstractReductionFunctionEntity;
import org.opennms.netmgt.model.OnmsMonitoredService;

public class BusinessServiceEntityBuilder {
    private String name;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private List<EdgeDefinition<BusinessServiceEntity>> children = new ArrayList<EdgeDefinition<BusinessServiceEntity>>();
    private List<EdgeDefinition<OnmsMonitoredService>> ipServices = new ArrayList<EdgeDefinition<OnmsMonitoredService>>();
    private List<EdgeDefinition<String>> reductionKeys = new ArrayList<EdgeDefinition<String>>();
    private Long id;
    private AbstractReductionFunctionEntity reduceFunction;

    public BusinessServiceEntityBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BusinessServiceEntityBuilder addAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public BusinessServiceEntityBuilder id(Long id) {
        this.id = id;
        return this;
    }

    public BusinessServiceEntity toEntity() {
        BusinessServiceEntity entity = new BusinessServiceEntity();
        entity.setName(this.name);
        entity.setId(this.id);
        entity.setAttributes(this.attributes);
        if (this.reduceFunction != null) {
            entity.setReductionFunction(this.reduceFunction);
        }
        this.ipServices.forEach(e -> entity.addIpServiceEdge((OnmsMonitoredService)((EdgeDefinition)e).value, ((EdgeDefinition)e).mapFunction, ((EdgeDefinition)e).weight, ((EdgeDefinition)e).friendlyName));
        this.children.forEach(e -> entity.addChildServiceEdge((BusinessServiceEntity)((EdgeDefinition)e).value, ((EdgeDefinition)e).mapFunction, ((EdgeDefinition)e).weight));
        this.reductionKeys.forEach(e -> entity.addReductionKeyEdge((String)((EdgeDefinition)e).value, ((EdgeDefinition)e).mapFunction, ((EdgeDefinition)e).weight, ((EdgeDefinition)e).friendlyName));
        return entity;
    }

    public BusinessServiceEntityBuilder addIpService(OnmsMonitoredService ipService, AbstractMapFunctionEntity mapFunctionEntity) {
        return this.addIpService(ipService, mapFunctionEntity, 1);
    }

    public BusinessServiceEntityBuilder addIpService(OnmsMonitoredService ipService, AbstractMapFunctionEntity mapFunctionEntity, int weight) {
        this.ipServices.add(new EdgeDefinition<OnmsMonitoredService>(ipService, mapFunctionEntity, weight, null));
        return this;
    }

    public BusinessServiceEntityBuilder addReductionKey(String reductionKey, AbstractMapFunctionEntity mapFunctionEntity, String friendlyName) {
        return this.addReductionKey(reductionKey, mapFunctionEntity, 1, friendlyName);
    }

    public BusinessServiceEntityBuilder addReductionKey(String reductionKey, AbstractMapFunctionEntity mapFunctionEntity) {
        return this.addReductionKey(reductionKey, mapFunctionEntity, 1, null);
    }

    public BusinessServiceEntityBuilder addReductionKey(String reductionKey, AbstractMapFunctionEntity mapFunctionEntity, int weight) {
        return this.addReductionKey(reductionKey, mapFunctionEntity, weight, null);
    }

    public BusinessServiceEntityBuilder addReductionKey(String reductionKey, AbstractMapFunctionEntity mapFunctionEntity, int weight, String friendlyName) {
        this.reductionKeys.add(new EdgeDefinition<String>(reductionKey, mapFunctionEntity, weight, friendlyName));
        return this;
    }

    public BusinessServiceEntityBuilder addChildren(BusinessServiceEntity child, AbstractMapFunctionEntity mapFunctionEntity) {
        return this.addChildren(child, mapFunctionEntity, 1);
    }

    public BusinessServiceEntityBuilder addChildren(BusinessServiceEntity child, AbstractMapFunctionEntity mapFunctionEntity, int weight) {
        this.children.add(new EdgeDefinition<BusinessServiceEntity>(child, mapFunctionEntity, weight, null));
        return this;
    }

    public BusinessServiceEntityBuilder reduceFunction(AbstractReductionFunctionEntity reductionFunction) {
        this.reduceFunction = reductionFunction;
        return this;
    }

    private class EdgeDefinition<V> {
        private final V value;
        private final String friendlyName;
        private final AbstractMapFunctionEntity mapFunction;
        private final int weight;

        public EdgeDefinition(V value, AbstractMapFunctionEntity mapFunction, int weight, String friendlyName) {
            this.value = value;
            this.mapFunction = mapFunction;
            this.weight = weight;
            this.friendlyName = friendlyName;
        }
    }
}

