/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.internal.IpServiceImpl;
import org.opennms.netmgt.bsm.service.model.Application;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.dao.util.ReductionKeyHelper;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;

public class ApplicationImpl
implements Application {
    private final BusinessServiceManager m_manager;
    private final OnmsApplication m_entity;

    public ApplicationImpl(BusinessServiceManager manager, OnmsApplication entity) {
        this.m_manager = manager;
        this.m_entity = entity;
    }

    public String getApplicationName() {
        return this.m_entity.getName();
    }

    public OnmsApplication getEntity() {
        return this.m_entity;
    }

    public int getId() {
        return this.m_entity.getId();
    }

    public Set<String> getReductionKeys() {
        return Collections.unmodifiableSet(ReductionKeyHelper.getReductionKeys((OnmsApplication)this.m_entity));
    }

    public Set<IpService> getIpServices() {
        return Collections.unmodifiableSet(this.m_entity.getMonitoredServices().stream().map(e -> new IpServiceImpl(this.m_manager, (OnmsMonitoredService)e)).collect(Collectors.toSet()));
    }

    public Set<Integer> getNodeIds() {
        return Collections.unmodifiableSet(this.m_entity.getMonitoredServices().stream().map(s -> s.getNodeId()).collect(Collectors.toSet()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationImpl other = (ApplicationImpl)obj;
        return Objects.equals(this.getEntity(), other.getEntity());
    }

    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("m_manager", (Object)this.m_manager).add("m_entity", (Object)this.m_entity).toString();
    }
}

