/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal.edge;

import java.util.Objects;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeEntity;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.internal.BusinessServiceImpl;
import org.opennms.netmgt.bsm.service.internal.MapFunctionMapper;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;

public abstract class AbstractEdge<T extends BusinessServiceEdgeEntity>
implements Edge {
    private final T m_entity;
    private final BusinessServiceManager m_manager;

    public AbstractEdge(BusinessServiceManager manager, T entity) {
        this.m_manager = manager;
        this.m_entity = entity;
    }

    public Long getId() {
        return this.m_entity.getId();
    }

    public T getEntity() {
        return this.m_entity;
    }

    public BusinessService getSource() {
        return new BusinessServiceImpl(this.m_manager, this.m_entity.getBusinessService());
    }

    public void setSource(BusinessService source) {
        this.getEntity().setBusinessService(((BusinessServiceImpl)source).getEntity());
    }

    public Status getOperationalStatus() {
        return this.getManager().getOperationalStatus((Edge)this);
    }

    public void setMapFunction(MapFunction mapFunction) {
        this.m_manager.setMapFunction((Edge)this, mapFunction);
    }

    public MapFunction getMapFunction() {
        return new MapFunctionMapper().toServiceFunction(this.getEntity().getMapFunction());
    }

    public int getWeight() {
        return this.getEntity().getWeight();
    }

    public void setWeight(int weight) {
        this.getEntity().setWeight(weight);
    }

    public void delete() {
        this.getManager().deleteEdge(this.getSource(), (Edge)this);
    }

    protected BusinessServiceManager getManager() {
        return this.m_manager;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEdge other = (AbstractEdge)obj;
        return Objects.equals(this.getEntity(), other.getEntity());
    }

    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("reductionKeys", (Object)this.getReductionKeys()).add("status", (Object)this.getOperationalStatus()).add("mapFunction", (Object)this.getMapFunction()).add("source", this.getSource() == null ? this.getSource() : this.getSource().getId()).toString();
    }
}

