/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.functions.reduce;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Function;
import org.opennms.netmgt.bsm.service.model.functions.annotations.Parameter;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReduceFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;

@Function(name="HighestSeverityAbove", description="Uses the highest severity greater than the given threshold severity")
public class HighestSeverityAbove
implements ReductionFunction {
    @Parameter(key="threshold", description="The status value to use as threshold")
    private Status threshold;

    @Override
    public Optional<Status> reduce(List<Status> statuses) {
        return statuses.stream().filter(s -> s.isGreaterThan(this.threshold)).reduce((a, b) -> a.isGreaterThan((Status)b) ? a : b);
    }

    public void setThreshold(Status threshold) {
        this.threshold = Objects.requireNonNull(threshold);
    }

    public Status getThreshold() {
        return this.threshold;
    }

    @Override
    public <T> T accept(ReduceFunctionVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

