/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2.bsm.model;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.web.rest.api.ResourceLocation;
import org.opennms.web.rest.api.ResourceLocationFactory;
import org.opennms.web.rest.api.support.JAXBResourceLocationAdapter;
import org.opennms.web.rest.api.support.JsonResourceLocationListDeserializationProvider;
import org.opennms.web.rest.api.support.JsonResourceLocationListSerializationProvider;

@XmlRootElement(name="business-services")
@JsonRootName(value="business-services")
public class BusinessServiceListDTO {
    private List<ResourceLocation> services;

    public BusinessServiceListDTO() {
    }

    public BusinessServiceListDTO(Collection<? extends BusinessService> services) {
        this.services = services.stream().map(service -> ResourceLocationFactory.createBusinessServiceLocation((String)Long.toString(service.getId()))).collect(Collectors.toList());
    }

    @XmlElement(name="business-service")
    @JsonProperty(value="business-services")
    @JsonSerialize(using=JsonResourceLocationListSerializationProvider.class)
    @JsonDeserialize(using=JsonResourceLocationListDeserializationProvider.class)
    @XmlJavaTypeAdapter(value=JAXBResourceLocationAdapter.class)
    public List<ResourceLocation> getServices() {
        return this.services;
    }

    public void setServices(List<ResourceLocation> services) {
        this.services = services;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BusinessServiceListDTO other = (BusinessServiceListDTO)obj;
        return Objects.equals(this.services, other.services);
    }

    public int hashCode() {
        return Objects.hash(this.services);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("services", this.services).toString();
    }
}

