/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceChildEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.IPServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.SingleReductionKeyEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.AbstractMapFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.AbstractReductionFunctionEntity;
import org.opennms.netmgt.model.OnmsMonitoredService;

@Entity
@Table(name="bsm_service")
public class BusinessServiceEntity {
    private Long m_id;
    private String m_name;
    private Map<String, String> m_attributes = Maps.newLinkedHashMap();
    private Set<BusinessServiceEdgeEntity> m_edges = Sets.newLinkedHashSet();
    private AbstractReductionFunctionEntity m_reductionFunction;
    private int level = -1;

    public void setLevel(int level) {
        this.level = level;
    }

    @Transient
    public int getLevel() {
        return this.level;
    }

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    @Column(name="id", nullable=false)
    public Long getId() {
        return this.m_id;
    }

    public void setId(Long id) {
        this.m_id = id;
    }

    @Column(name="name", nullable=false, unique=true)
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @JoinTable(name="bsm_service_attributes", joinColumns={@JoinColumn(name="bsm_service_id", referencedColumnName="id")})
    @MapKeyColumn(name="key")
    @Column(name="value", nullable=false)
    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.m_attributes = attributes;
    }

    public void setAttribute(String key, String value) {
        this.m_attributes.put(key, value);
    }

    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="businessService", orphanRemoval=true)
    public Set<BusinessServiceEdgeEntity> getEdges() {
        return this.m_edges;
    }

    public void setEdges(Set<BusinessServiceEdgeEntity> edges) {
        this.m_edges = edges;
    }

    public void addEdge(BusinessServiceEdgeEntity edge) {
        this.m_edges.add(edge);
    }

    public boolean removeEdge(BusinessServiceEdgeEntity edge) {
        return this.m_edges.remove(edge);
    }

    @Transient
    public Set<IPServiceEdgeEntity> getIpServiceEdges() {
        return this.getEdges(IPServiceEdgeEntity.class);
    }

    @Transient
    public Set<BusinessServiceChildEdgeEntity> getChildEdges() {
        return this.getEdges(BusinessServiceChildEdgeEntity.class);
    }

    @Transient
    public Set<SingleReductionKeyEdgeEntity> getReductionKeyEdges() {
        return this.getEdges(SingleReductionKeyEdgeEntity.class);
    }

    @Transient
    private <T extends BusinessServiceEdgeEntity> Set<T> getEdges(Class<T> type) {
        return this.getEdges().stream().filter(e -> type.isInstance(e)).map(e -> e).collect(Collectors.toSet());
    }

    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="bsm_reduce_id")
    public AbstractReductionFunctionEntity getReductionFunction() {
        return this.m_reductionFunction;
    }

    public void setReductionFunction(AbstractReductionFunctionEntity reductionFunction) {
        this.m_reductionFunction = Objects.requireNonNull(reductionFunction);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BusinessServiceEntity)) {
            return false;
        }
        BusinessServiceEntity other = (BusinessServiceEntity)obj;
        if (this.getId() != null) {
            return this.getId().equals(other.getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("id", (Object)this.m_id).add("name", (Object)this.m_name).add("attributes", this.m_attributes).add("edges", this.m_edges).toString();
    }

    public BusinessServiceEntity addChildServiceEdge(BusinessServiceEntity child, AbstractMapFunctionEntity mapFunction) {
        return this.addChildServiceEdge(child, mapFunction, 1);
    }

    public BusinessServiceEntity addChildServiceEdge(BusinessServiceEntity child, AbstractMapFunctionEntity mapFunction, int weight) {
        BusinessServiceChildEdgeEntity edge = new BusinessServiceChildEdgeEntity();
        edge.setBusinessService(this);
        edge.setChild(Objects.requireNonNull(child));
        edge.setWeight(weight);
        edge.setMapFunction(Objects.requireNonNull(mapFunction));
        this.addEdge(edge);
        return this;
    }

    public BusinessServiceEntity addIpServiceEdge(OnmsMonitoredService ipService, AbstractMapFunctionEntity mapFunction) {
        return this.addIpServiceEdge(ipService, mapFunction, 1, null);
    }

    public BusinessServiceEntity addIpServiceEdge(OnmsMonitoredService ipService, AbstractMapFunctionEntity mapFunction, int weight, String friendlyName) {
        IPServiceEdgeEntity edge = new IPServiceEdgeEntity();
        edge.setBusinessService(this);
        edge.setIpService(Objects.requireNonNull(ipService));
        edge.setWeight(weight);
        edge.setMapFunction(Objects.requireNonNull(mapFunction));
        edge.setFriendlyName(friendlyName);
        this.addEdge(edge);
        return this;
    }

    public BusinessServiceEntity addReductionKeyEdge(String reductionKey, AbstractMapFunctionEntity mapFunction) {
        return this.addReductionKeyEdge(reductionKey, mapFunction, 1, null);
    }

    public BusinessServiceEntity addReductionKeyEdge(String reductionKey, AbstractMapFunctionEntity mapFunction, int weight, String friendlyName) {
        SingleReductionKeyEdgeEntity edge = new SingleReductionKeyEdgeEntity();
        edge.setBusinessService(this);
        edge.setReductionKey(Objects.requireNonNull(reductionKey));
        edge.setWeight(weight);
        edge.setMapFunction(Objects.requireNonNull(mapFunction));
        edge.setFriendlyName(friendlyName);
        this.addEdge(edge);
        return this;
    }
}

